const { pipeActivityInfo } = require('./base.controller');
const UserJoinService = require("../service/userJoin.service");
const UserService = require('../service/user.service');
const StatService = require("../service/stat.service");
const { CODE_TYPES, ONCE_DIAMOND_REDUCE, JOIN_INFO_STATUS, DATA_TYPE, SHOE_TYPE_REWARDS, SHOE_TYPE_MAP, USE_SHOES_DATA } = require('../constants');
const { getToday, getSellerSession } = require('../utils');
const { ResultsModel } = require('../sdk');
let resultModel = new ResultsModel();

const getGameInfo = async context => {
  // const pipeRes = await pipeActivityInfo(context);
  // if (pipeRes.code) {
  //   return pipeRes;
  // }
  let { activityId } = context.data;
  let { openId } = context;

  const userService = new UserService(context);
  const userJoinSer = new UserJoinService(context);
  const userInfo = await userService.getUserInfo();
  if (!userInfo) return resultModel.error(CODE_TYPES.ERROR_NO_USER);

  let { diamond, resurgenceCards, member, toolInfo } = userInfo;

  //初始积分
  let { session } = await getSellerSession(context, activityId);
  let initialCredits = await userService.queryUserCredits(session) || 0 
  console.log('initialCredits:'+initialCredits)

  let joinCount = await userJoinSer.getJoinCount({activityId, openId});

  let result = {
    diamond,
    resurgenceCards,
    guideComplete: joinCount > 0,
    initialCredits: member.flag ? initialCredits : 0,
    toolInfo
  }
  return resultModel.success(result);
}

// 开始游戏
const startGame = async context => {
  let pipeRes = await pipeActivityInfo(context);
  if (pipeRes.code) {
    return pipeRes;
  }

  const userService = new UserService(context);
  const statService = new StatService(context);
  const userInfo = await userService.getUserInfo();
  const userJoinSer = new UserJoinService(context);
  
  if (!userInfo) return resultModel.error(CODE_TYPES.ERROR_NO_USER);

  let { activityId } = context.data;
  const { openId } = context

  const { diamond, userNick, maxScore, shoes, member } = userInfo;

  if (diamond < ONCE_DIAMOND_REDUCE) {
    return resultModel.error(CODE_TYPES.ERROR_NO_GAME_COUNT);
  }

  let joinCount = await userJoinSer.getJoinCount({activityId, openId});
  let todayJoinCount = await userJoinSer.getJoinCount({activityId, openId, createDay: getToday() });
  const joinId = await userJoinSer.insertGameInfo({ userNick, maxScore, shoes, score: 0, isVip: member.flag, cards: 0 });
  let lastTool = await userJoinSer.getLastGameInfo()
  console.log('lastTool'+JSON.stringify(lastTool))
  let lastToolType = (lastTool && lastTool.toolType) ? lastTool.toolType : 1

  await userService.updateUser(userInfo._id, {
    guideComplete: joinCount > 0
  });

  return resultModel.success({
    id: joinId,
    guideComplete: joinCount > 0,
    isFirstTime: todayJoinCount == 0,
    lastToolType
  });
}

const submitGame = async context => {
  const { activityId, id, score, shoes } = context.data;

  if (!activityId) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `activityId必填`);
  }
  if (!id) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `id必填`);
  }
  if (!score && score !== 0) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `score必填`);
  }
  if (!shoes && shoes !== 0) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `shoes必填`);
  }

  let pipeRes = await pipeActivityInfo(context);
  if (pipeRes.code) {
    return pipeRes;
  }

  const userService = new UserService(context);
  const userJoinSer = new UserJoinService(context);
  const statService = new StatService(context);

  const userInfo = await userService.getUserInfo();
  if (!userInfo) return resultModel.error(CODE_TYPES.ERROR_NO_USER);

  const joinInfo = await userJoinSer.getGameInfo(id,activityId);

  if (!joinInfo) return resultModel.error(CODE_TYPES.ERROR_NO_JOIN_INFO);

  if (!(joinInfo.status && joinInfo.status == JOIN_INFO_STATUS.START)) {
    resultModel.error(CODE_TYPES.ERROR_JOIN_STATUS_ERROR);
  }

  let { totalScore:oldTotalScore, maxScore, totalShoes:oldShoes, resurgenceCards:oldCards } = userInfo
  let newMaxScore = +maxScore > score ? maxScore : parseInt(score)
  await userJoinSer.updateGameInfo(id, activityId, {
    submitGame: Date.now(),
    submitDay: getToday(),
    score: parseInt(score),
    maxScore: newMaxScore,
    duration: Date.now() - joinInfo.createTime,
    status: JOIN_INFO_STATUS.FINISH
  });

  const totalScore = +oldTotalScore + parseInt(score);
  const totalShoes = oldShoes + shoes;

  await userService.updateUser(userInfo._id, {
    totalScore,
    totalShoes,
    maxScoreTime: Date.now(),
    maxScore: newMaxScore,
  });

  const { rank } = await userService.getUserRank(newMaxScore);
  console.log('rank:'+rank)
  const list = await userService.getSideScoreUser(newMaxScore,rank)
  console.log('rankList:'+list)
  //埋点统计
  await statService.addStatNumberUv({ activityId, type: DATA_TYPE.addShoesUv, value: shoes })

  return resultModel.success({
    score,
    rankList:list,
    maxScore: newMaxScore,
    shoes
  });
}

//选择道具
const chooseTool = async context => {
  const { openId } = context
  const { activityId, id, toolType} = context.data;

  if (!activityId) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `activityId必填`);
  }
  if (!toolType) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `toolType必填`);
  }

  const userService = new UserService(context);
  const userInfo = await userService.getUserInfo();
  if (!userInfo) return resultModel.error(CODE_TYPES.ERROR_NO_USER);

  const userJoinSer = new UserJoinService(context);
  const statService = new StatService(context);
  const joinCount = await userJoinSer.getJoinCount({activityId, openId});
  const joinInfo = await userJoinSer.getGameInfo(id,activityId);

  if (!joinInfo) return resultModel.error(CODE_TYPES.ERROR_NO_JOIN_INFO);

  let { diamond } = userInfo

  //完成新手引导赠送 1次款鞋2 toolType == 2 && joinCount === 1

  if(toolType == 1 || (toolType == 2 && joinCount === 1)) {
    await userJoinSer.updateGameInfo(id, activityId, {
      toolType,
    });
    await statService.addStat({ activityId, type: USE_SHOES_DATA[toolType] });
    //埋点数据 消耗砖石
    await statService.addStatNumberUv({ activityId, type: DATA_TYPE.reduceDiamondUv, value: ONCE_DIAMOND_REDUCE })

    await userService.updateUser(userInfo._id, {
      diamond: diamond > ONCE_DIAMOND_REDUCE ? diamond - ONCE_DIAMOND_REDUCE : 0
    });
    return resultModel.success({
      id,
      toolType,
      diamond: diamond > ONCE_DIAMOND_REDUCE ? diamond - ONCE_DIAMOND_REDUCE : 0
    })
  }

  if(+diamond < (SHOE_TYPE_REWARDS[toolType] + ONCE_DIAMOND_REDUCE)) {
    return resultModel.error(CODE_TYPES.ERROR_NO_GAME_COUNT);
  }
  await userJoinSer.updateGameInfo(id, activityId, {
    toolType
  });

  //兑换鞋子
  await userService.updateUser(userInfo._id, {
    diamond: +diamond - (SHOE_TYPE_REWARDS[toolType] + ONCE_DIAMOND_REDUCE)
  });
  //消耗砖石打点
  await statService.addStatNumberUv({ activityId, type:DATA_TYPE.reduceDiamondUv, value: (SHOE_TYPE_REWARDS[toolType] + ONCE_DIAMOND_REDUCE) });
  await statService.addStat({ activityId, type: USE_SHOES_DATA[toolType] });

  return resultModel.success({
    id,
    toolType,
    diamond: +diamond - (SHOE_TYPE_REWARDS[toolType] + ONCE_DIAMOND_REDUCE)
  })
}

//游戏复活
const doResurrection = async context => {
  const { activityId, id } = context.data;
  if (!activityId) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `activityId必填`);
  }
  if (!id) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `id必填`);
  }

  const userService = new UserService(context);
  const userJoinSer = new UserJoinService(context);
  const statService = new StatService(context);

  const userInfo = await userService.getUserInfo();
  if (!userInfo) return resultModel.error(CODE_TYPES.ERROR_NO_USER);
  let { resurgenceCards: oldCards } = userInfo
  if(oldCards < 1) {
    return resultModel.error(CODE_TYPES.ERROR_NO_CARD_COUNT);
  }
  const joinInfo = await userJoinSer.getGameInfo(id,activityId);

  if (!joinInfo) return resultModel.error(CODE_TYPES.ERROR_NO_JOIN_INFO);
  let { cards } = joinInfo

  if(cards && cards >= 2) {
   return resultModel.error(CODE_TYPES.ERROR_NO_USE_CARD);
  }
  await userJoinSer.updateGameInfo(id, activityId, {
    cards: cards ? cards + 1 : 1
  });

  const resurgenceCards = oldCards > 1 ? oldCards - 1 : 0;
  await userService.updateUser(userInfo._id, {
    resurgenceCards
  });
  await statService.addStatNumberUv({ activityId, type: DATA_TYPE.reduceCardUv, value: 1 })

  return resultModel.success({
    id,
    resurgenceCards: oldCards > 1 ? oldCards - 1 : 0
  });
}

module.exports = {
  getGameInfo,
  startGame,
  submitGame,
  chooseTool,
  doResurrection
}