const { pipeActivityInfo } = require('./base.controller');
const UserService = require('../service/user.service');
const AwardsService = require('../service/awards.service');
const { CODE_TYPES } = require('../constants');
const { ResultsModel } = require('../sdk');
let resultModel = new ResultsModel();

/**
 * 我的奖品列表
 * @param {*} context 
 */
const getMyPrizeList = async (context) => {
  // 判断活动
  let pipeRes = await pipeActivityInfo(context);
  // 活动结束可以查看我的奖品
  if (pipeRes.code && pipeRes.code !== CODE_TYPES.ERROR_ACTIVITY_OVER.code) {
    return pipeRes;
  }
  let awardSer = new AwardsService(context);
  let result = await awardSer.getMyPrizeList({openId: context.openId, activityId: context.data.activityId});
  return resultModel.success(result);
}
/**
 * 领取实物
 * @param {*} context 
 */
const receiveObjectPrize = async(context) => {
  // 判断活动
  let pipeRes = await pipeActivityInfo(context);
  // 活动结束可以领取实物
  if (pipeRes.code && pipeRes.code !== CODE_TYPES.ERROR_ACTIVITY_OVER.code) {
    return pipeRes;
  }
  let { provinceName, cityName, detailInfo, countyName, streetName, cityCode, _id, name, phone, activityId } = context.data;
  if (!_id) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `缺少_id`)
  }
  if (!name) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `缺少name`)
  }
  if (!phone) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `缺少phone`)
  }
  if (!provinceName) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `缺少provinceName`)
  }
  if (!cityName) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `缺少cityName`)
  }
  if (!countyName) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `缺少countyName`)
  }
  if (!detailInfo) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `缺少detailInfo`)
  }
  let awardSer = new AwardsService(context);
  let result = await awardSer.recieveObjectPrize(_id, {activityId, provinceName, cityName, detailInfo, countyName, streetName, cityCode, name, phone});
  if (result.code) {
    return resultModel.error(result);
  }
  return resultModel.success(result);
}

/**
 * 权益重新领取
 * @param {*} context 
 */
const receiveEnamePrize = async(context) => {
  let pipeRes = await pipeActivityInfo(context);
  // 活动结束可以领取权益
  if (pipeRes.code && pipeRes.code !== CODE_TYPES.ERROR_ACTIVITY_OVER.code) {
    return pipeRes;
  }
  let {_id} = context.data;
  if (!_id) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `缺少_id`)
  }
  let awardsSer = new AwardsService(context);
  let result = await awardsSer.recieveEnamePrize(_id, pipeRes._id);
  if (result.code) {
    return resultModel.error(result);
  }
  if (result.remark) {
    return resultModel.error(result, result.remark);
  }
  return resultModel.success(result);
}


module.exports = {
  getMyPrizeList,
  receiveObjectPrize,
  receiveEnamePrize
}