const { DEFAULT_CODE_TYPES } = require('./sdk');

let BusinessError = {
  // 更新重试失败(用于并发更新)
  ERROR_UPDATE_RETRY: {
    code: `210001`,
    defaultMsg: `系统错误`
  },
  // 活动不存在
  ERROR_NO_ACTIVITY: {
    code: `220001`,
    defaultMsg: `活动不存在`
  },
  // 活动未开始
  ERROR_ACTIVITY_NOSTART: {
    code: `220002`,
    defaultMsg: `活动未开始`
  },
  // 活动已结束
  ERROR_ACTIVITY_OVER: {
    code: `220003`,
    defaultMsg: `活动已结束`
  },
  // 排行榜未开奖
  ERROR_NO_RANKOEPN:{
    code: `220004`,
    defaultMsg: `排行榜未开奖`
  },
  // 当局复活卡使用次数已达上限
  ERROR_NO_USE_CARD:{
    code: `220005`,
    defaultMsg: `当局游戏最多只能使用2张复活卡哦`
  },
  // 用户不存在
  ERROR_NO_USER: {
    code: `310002`,
    defaultMsg: `用户不存在`
  },
  // 需要成为会员才能助力哦
  ERROR_NEEDMEMBER_DOHELP: {
    code: `310004`,
    defaultMsg: '需要成为会员才能助力哦'
  },
  // 任务奖励已领取
  ERROR_TASK_ALREADYRECEIVE: {
    code: `430002`,
    defaultMsg: `任务奖励已领取`
  },
  // 任务已完成
  ERROR_TASK_COMPLETE: {
    code: `430003`,
    defaultMsg: `任务已完成`
  },
  // 暂无次数可领取
  ERROR_TASK_NORECEIVE: {
    code: `430003`,
    defaultMsg: `暂无次数可领取`
  },
  ERROR_FORBIDDEN_OPE: {
    code: `530001`,
    defaultMsg: `非法操作`
  },
  ERROR_RECEIVE_PRIZE: {
    code: `630002`,
    defaultMsg: `奖励已领取`
  },
  ERROR_SEND_PRIZE: {
    code: `730001`,
    defaultMsg: `发奖失败`
  },
  ERROR_NO_PRIZE: {
    code: `730002`,
    defaultMsg: `奖品不存在`
  },
  ERROR_NO_STOCK: {
    code: `730003`,
    defaultMsg: `库存不足`
  },
  ERROR_PRIZE_EXPIRED: {
    code: `740001`,
    defaultMsg: `奖品已超过领取时间`
  },
  ERROR_TASK_NORECEIVE: {
    code: `930002`,
    defaultMsg: `该任务不可领取`
  },
  ERROR_NOT_NEW_USER: {
    code: `930003`,
    defaultMsg: `新玩家才可以助力哦`
  },
  ERROR_NOT_VIP: {
    code: `930004`,
    defaultMsg: `成为会员才能为TA助力哦！`
  },
  ERROR_INVALID_INVITE_USER: {
    code: `930005`,
    defaultMsg: `inviteId无效`
  },
  ERROR_ASSIST_ALREADY: {
    code: `930006`,
    defaultMsg: `已为好友成功助力过了`
  },
  ERROR_NO_VIP: {
    code: `930007`,
    defaultMsg: `请先加入会员`
  },
  ERROR_EXCHANGE_FAIL: {
    code: `930008`,
    defaultMsg: `兑换失败，请稍后再试`
  },
  ERROR_NO_MySELF: {
    code: `930009`,
    defaultMsg: `自己不能给自己助力哦`
  },
  ERROR_CREDIT_NUM: {
    code: `100001`,
    defaultMsg: `积分不足`
  },
  ERROR_NO_GAME_COUNT: {
    code: `100002`,
    defaultMsg: `钻石不足`
  },
  ERROR_NO_CARD_COUNT: {
    code: `100003`,
    defaultMsg: `复活卡不足`
  }
}

const TASK_LIST = [
   {
    taskType: 'follow',
    rewards:10,//钻石
    status: 0
  },
  {
    taskType: 'sign',
    rewards: 10,//钻石
    status: 0
  },
  {
    taskType: 'orderGoods',
    rewards: 5,//复活卡
    status: 0
  },
  {
    taskType: 'inviteFriends',
    status: 0,
    rewards: 20,//钻石
    value: 1,//复活卡
  },
  {
    taskType: 'browseGoods',
    rewards: 1,//复活卡
    status: 0
  },
  {
    taskType: 'exchangeCredits',
    limitTimes: 2,
    rewards: 10,//钻石
    times: 0,
    value: 20
  }
]

const CODE_TYPES = Object.assign({}, DEFAULT_CODE_TYPES, BusinessError);

//tb 接口返回部分错误
const TBERROR = {
  'USER_PERMISSION_EXCEED_MAX_RIGHT_COUNT_IN_DAY': '今日领取达到上限，明日再来领取哦',
  'COUPON_INVALID_OR_DELETED': '权益无效或者被删除，请联系商家',
  'APPLY_OWNSELF_COUPON': '不能领取自己家店铺权益',
  'APPLY_SINGLE_COUPON_COUNT_EXCEED_LIMIT': '请至卡券包删除无用权益再领取',
  'NO_RIGHT_QUANTITY': '权益库存不足，请联系商家',
  'ERRORA_3_567': '领取失败，为风险用户',
  'Invalid session': '订购应用已过期，请联系商家处理',
  'NO_RIGHT_QUANTITY': '权益库存不足，请联系商家'
}

// 领取奖品状态
const DRAW_STATUS = {
  // 待领取
  WAITAWARD: 1,
  // 处理中
  PROCESSING: 2,
  // 领取成功
  SUCCESS: 3,
  // 领取失败
  FAIL: 4,
  // 已过期
  EXPIRED: 5,
  // 重新领取
  RETRY: 6
}

// 物流状态
const SHIP_STATUS = {
  //未填写收货地址
  NO_ADDRESS: 1,
  //未发货
  UNSHIPPED: 2,
  //已发货
  SHIPPED: 3
}

// 奖品类型
const PRIZE_TYPE = {
  ENAME: 1,
  CREDITS: 2,
  OBJECT: 3,
  THANKS: 5
};
// C端的APP NAME
const C_APP_NAME = 'promotioncenter-3000000026263524';

//商家店铺地址
const SHOP_URL = 'http://shop112900255.m.taobao.com'

//加入会员后回调 &query=activityId%3D5f34e1c4964f9706aa7d803c&inviteId%3D12222
const CALL_BACK_URL = 'https://m.duanqu.com?_ariver_appid=3000000026263524&nbsv=0.1.2008191102.0&nbsource=debug&nbsn=DEBUG&_mp_code=tb&query'

// 订单状态 WAIT_BUYER_PAY：等待买家付款
const TAOBAO_SUCCESS_ORDER_STATUS = [
  "WAIT_SELLER_SEND_GOODS",//等待卖家发货
  "SELLER_CONSIGNED_PART",//卖家部分发货
  "WAIT_BUYER_CONFIRM_GOODS",//等待买家确认收货
  "TRADE_BUYER_SIGNED",//买家已签收（货到付款专用）
  "TRADE_FINISHED",//交易成功
  "PAID_FORBID_CONSIGN",//该状态代表订单已付款但是处于禁止发货状态。
];
// 活动状态
const ACTIVITY_STATUS = {
  NORMAL: 1,
  DELETE: 2
};

//鞋子类型map
const SHOE_TYPE_MAP = {
  1: "normal",//新用户赠送 款鞋一
  2: "primary",//款鞋二 1次免伤
  3: "medium"//款鞋三 2次免伤
};
const NORMAL_TOOL_TYPE = 1;

//每局游戏消耗10钻石
const ONCE_DIAMOND_REDUCE = 10

const NEW_USER_DIAMAND = 20

const SHOE_TYPE_REWARDS = {
  1: 0,
  2: 10,//10钻石兑换1次免伤
  3: 20//20钻石兑换2次免伤
}

// 任务类型
const TASK_TYPE = {
  //1秒入会
  MEMBER: 'member',
  //每日免费
  FREE_MASONRYS: 'sign',
  // 邀请好友
  INVITES: 'inviteFriends',
  // 购买商品
  BUY_GOODS: 'orderGoods',
  // 关注店铺
  FOLLOW: 'follow',
  // 浏览商品
  BROWSE: 'browseGoods',
  //积分兑换
  EXCHANAGE: 'exchangeCredits',
}
//任务奖励
const TASK_TYPE_WIN = {
  // 1秒入会得复活卡
  MEMBER: 1,
  //每日登录
  DAY: 10,
  // 邀请好友得20钻石
  INVITES: 20,
  //邀请好友非店铺会员得复活卡
  NEN_INVITES: 2,
  // 购买商品得复活卡
  BUY_GOODS: 5,
  // 关注店铺
  FOLLOW: 10,
  // 浏览商品得复活卡
  BROWSE: 1,
  //积分兑换
  EXCHANAGE_CREDITS: 10,
}

//20积分兑换10钻石
const EXCHANAGE_CREDITS  = 20

//任务频率类型常量
const TASK_RATE_TYPE = {
  FOREVER: 1,
  EVERYDAY: 2,
  NOLIMIT: 3,
};

// 积分兑换限制
const EXCHANGE_CREDITS_LIMIT = { value: 2, type: TASK_RATE_TYPE.EVERYDAY };

// 浏览商品限制
const BROSER_LIMIT = { value: 1, type: TASK_RATE_TYPE.EVERYDAY };

// 邀请好友限制
const INVITE_FRIENDS_LIMIT = { value: 5, type: TASK_RATE_TYPE.EVERYDAY };

//游戏记录状态
const JOIN_INFO_STATUS = {
  START: 0,
  FINISH: 1
}
//助力成功
const ASSIST_SUCCESS = 1

//助力成功 新入会获得30钻石
const FIRST_DIAMOND = 30

// 排行榜开奖状态
const OPEN_PRIZE_STATUS = {
  WAITOPEN: 1,
  OPENING: 2,
  SUCCESS: 3,
  FAIL: 4
};

//鞋子使用打点类型
const USE_SHOES_DATA = {
  1: 'useNormal',
  2: 'usePrimary',
  3: 'useMedium'
}

//埋点数据类型
const DATA_TYPE = {
  newAddUv:'newAddUv',//首次进入uv 1
  accesssPv:'accesssPv',//访问pv 1
  accesssUv:'accesssUv',//访问uv
  joinGamePv:'joinGamePv',//参与pv 1
  joinGameUv:'joinGameUv',//参与uv
  countFollow:'countFollow',//关注店铺完成pv 1
  dayLogin:'dayLogin',//每日登录任务完成 1
  dayLoginUv: 'dayLoginUv',
  completeInvited:'completeInvited',//邀请好友任务完成Pv 1
  invitedMember: 'invitedMember',//带来好友已入会(未入会isvip) 1
  beBrowse:'beBrowse',//每日浏览完成uv 1
  exchanageCredit:'exchanageCredit',//积分兑换钻石pv(前端)
  inviteFriend:'inviteFriend',//邀请好友发起Pv(前端)
  useNormal:'useNormal',//款鞋一使用pv 前端打点
  usePrimary:'usePrimary',//款鞋二使用pv 前端打点
  useMedium:'useMedium',//款鞋三使用pv 前端打点
  consumption:'consumption',//每日消费uv(点击去下单) (前端)
  exchanagePrize:'exchanagePrize',//每日兑换uv(兑换商场)(前端)
  addShoesUv:'addShoesUv',//获得碎片Uv 1
  reduceShoesUv:'reduceShoesUv',//使用碎片Uv
  addCardUv:'addCardUv',//获得复活卡Uv 1
  reduceCardUv:'reduceCardUv',//使用复活卡Uv 1
  reduceDiamondUv:'reduceDiamondUv',//消耗钻石Uv
  reduceCreditUv:'reduceCreditUv',//消耗积分Uv
  countDiamond:'countDiamond',//当日累计消耗钻石
  countCredit:'countCredit',//当日累计消耗积分
  countMember:'countMember',//入会人数
  countShoes:'countShoes',//碎片获取总量
  useCountShoes:'useCountShoes',//碎片使用总量
  countCards:'countCards',//复活卡获取总量
  useCountCards:'useCountCards',//复活卡使用总量
  assistRecord:'assistRecord',//助力记录
  orderPrice:'orderPrice',//订单价格
}

let rand = (function(){
  let seed = (new Date()).getTime()
  function r(){
    seed = (seed*9301+49297)%233280
    return seed/(233280.0)
  }
  return function(number){
    return Math.ceil(r()*number)
  }
})()

module.exports = {
  CODE_TYPES,
  C_APP_NAME,
  TBERROR,
  DRAW_STATUS,
  PRIZE_TYPE,
  TAOBAO_SUCCESS_ORDER_STATUS,
  ACTIVITY_STATUS,
  TASK_TYPE,
  SHIP_STATUS,
  OPEN_PRIZE_STATUS,
  TASK_TYPE_WIN,
  JOIN_INFO_STATUS,
  DATA_TYPE,
  ASSIST_SUCCESS,
  SHOE_TYPE_MAP,
  NORMAL_TOOL_TYPE,
  INVITE_FRIENDS_LIMIT,
  BROSER_LIMIT,
  EXCHANGE_CREDITS_LIMIT,
  FIRST_DIAMOND,
  TASK_LIST,
  SHOE_TYPE_REWARDS,
  ONCE_DIAMOND_REDUCE,
  EXCHANAGE_CREDITS,
  USE_SHOES_DATA,
  SHOP_URL,
  NEW_USER_DIAMAND,
  rand
}