/** @format */

// 排行榜开奖记录

import { BaseDao } from '../sdk'
import { AWARDS_DB_NAME } from '../db'

import { DRAW_STATUS, SHIP_STATUS } from '../constants'
export default class AwardsService {
  context: Context
  awardsdao: IBaseDao
  constructor(context: Context) {
    this.awardsdao = new BaseDao(context, AWARDS_DB_NAME)
  }

  // 添加排行榜待开奖列表
  async addWaitAwardsList(list) {
    if (!list.length) return true
    list = list.map(v => {
      return {
        ...v,
        drawStatus: DRAW_STATUS.WAITAWARD,
        message: ''
      }
    })
    try {
      await this.awardsdao.insertMany(list)
      return true
    } catch (e) {
      console.log(`添加排行榜待开奖列表出错：${e}`)
      return false
    }
  }

  // 根据活动id查找中奖名单
  async getAwardslistByActivityId(activityId: string, pageNo = 1, pageSize = 500) {
    if (!activityId) return false
    return await this.awardsdao.find(
      { activityId },
      {
        sort: {
          score: -1,
          rankTime: -1
        },
        limit: pageSize,
        skip: (pageNo - 1) * pageSize
      }
    )
  }

  //获取中奖名单长度
  async getAwardslistCount(activityId: string) {
    if (!activityId) {
      return false
    }
    return await this.awardsdao.count({
      activityId: activityId
    })
  }

  // 条件搜索--查询中奖信息
  async getUserPrizeByActivityId(
    activityId: string,
    pageNo: number,
    pageSize: number,
    prizeId: string,
    userNick: string,
    timeStart: number,
    timeEnd: number,
    shipStatus: number,
    type: number
  ) {
    let p = prizeId ? { _id: prizeId } : ''
    let u = userNick ? { userNick: { $regex: '.*' + userNick + '.*' } } : ''
    let c = timeStart > 0 && timeEnd > 0 ? { createTime: { $gt: timeStart, $lt: timeEnd } } : ''
    let s = shipStatus
      ? shipStatus == 1
        ? { shipStatus: { $in: [SHIP_STATUS.NO_ADDRESS, SHIP_STATUS.NO_SHIP, SHIP_STATUS.HAS_SHIP] } }
        : shipStatus == 2
        ? { shipStatus: { $in: [SHIP_STATUS.NO_ADDRESS, SHIP_STATUS.NO_SHIP] } }
        : { shipStatus: SHIP_STATUS.HAS_SHIP }
      : ''
    let t = type ? { type: +type } : ''
    let arr = [p, u, c, s, t]
    arr = arr.filter(i => {
      return i
    })
    console.log('arr--222---', arr)
    return await this.awardsdao.find(
      {
        activityId,
        $and: arr
      },
      {
        limit: pageSize,
        skip: (pageNo - 1) * pageSize
      }
    )
  }

  //《条件搜索》获取中奖名单长度
  async getTotalObjectCount(
    activityId: string,
    prizeId: string,
    userNick: string,
    timeStart: number,
    timeEnd: number,
    shipStatus: number,
    type: number
  ) {
    let p = prizeId ? { _id: prizeId } : ''
    let u = userNick ? { userNick: { $regex: '.*' + userNick + '.*' } } : ''
    let c = timeStart > 0 && timeEnd > 0 ? { createTime: { $gt: timeStart, $lt: timeEnd } } : ''
    let s = shipStatus
      ? shipStatus == 1
        ? { shipStatus: { $in: [SHIP_STATUS.NO_ADDRESS, SHIP_STATUS.NO_SHIP, SHIP_STATUS.HAS_SHIP] } }
        : shipStatus == 2
        ? { shipStatus: { $in: [SHIP_STATUS.NO_ADDRESS, SHIP_STATUS.NO_SHIP] } }
        : { shipStatus: SHIP_STATUS.HAS_SHIP }
      : ''
    let t = type ? { type: +type } : ''
    let arr = [p, u, c, s, t]
    arr = arr.filter(i => {
      return i
    })
    console.log('arr--111---', arr, 's>>>', s)
    return await this.awardsdao.count({
      activityId,
      $and: arr
    })
  }

  //《条件搜索》导入发货状态
  async setUserShipStatus(activityId: string, prizeId: string, shipCompany: string, shipNum: number | string) {
    prizeId = prizeId ? prizeId : '/'
    shipCompany = shipCompany ? shipCompany : ''
    shipNum = shipNum !== null ? shipNum : ''
    let status = 0
    if (shipCompany && shipNum) {
      status = SHIP_STATUS.HAS_SHIP
    } else {
      status = SHIP_STATUS.NO_SHIP
    }
    if (status == SHIP_STATUS.HAS_SHIP) {
      return await this.awardsdao.update(
        {
          activityId,
          _id: prizeId,
          shipStatus: SHIP_STATUS.NO_SHIP
        },
        {
          $set: {
            shipCompany,
            shipNum,
            shipStatus: SHIP_STATUS.HAS_SHIP
          }
        }
      )
    } else {
      return 0
    }
  }
}
