/** @format */
import { resultsModel } from '../sdk'
import { CODE_TYPES } from '../constants'
import Schema, { Rules } from 'async-validator'

export const paramsValidate = (validators: Rules) => {
  return function (target: Object, name: string, descriptor: PropertyDescriptor) {
    const method = descriptor.value

    descriptor.value = async function (...args: any[]) {
      const [context, otherArgs = {}] = args
      // @ts-ignore
      const { errors } = await validateParams(validators, context.data)

      console.log(errors)
      if (errors) return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, errors?.[0]?.message)

      return method.apply(target, [context, { ...otherArgs }])
    }
  }
}

const validateParams = (validators: Rules, data: object) => {
  const validator = new Schema(validators)

  return new Promise(resolve => {
    validator.validate(data, {}, (errors, fields) => {
      console.log('errors', errors)
      console.log('fields', fields)
      if (errors) {
        resolve({})
      } else {
        resolve({ errors, fields })
      }
    })
  })
}
