"use strict";
/** @format */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.exportHandlers = void 0;
exports.exportHandlers = function (controllers) {
    var handlersMapper = controllers
        .map(function (controller) {
        var controllerInstance = new controller();
        var handlersKeys = Object.getOwnPropertyNames(Object.getPrototypeOf(controllerInstance)).filter(function (v) { return v !== 'constructor'; });
        return handlersKeys.reduce(function (prev, current) {
            var _a;
            return __assign(__assign({}, prev), (_a = {}, _a[current] = controllerInstance[current], _a));
        }, {});
    })
        .reduce(function (prev, current) {
        return __assign(__assign({}, current), prev);
    }, {});
    return handlersMapper;
};
//# sourceMappingURL=exportHandlers.js.map