"use strict";
/** @format */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var constants_1 = require("./../constants");
var decorator_1 = require("../decorator");
var sdk_1 = require("../sdk");
var service_1 = require("../service");
var ActivityController = /** @class */ (function () {
    function ActivityController() {
    }
    /**
     *  活动基本信息
     */
    ActivityController.prototype.getActivityList = function (context, _a, _b) {
        var activityconfigService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var openId, result;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        openId = context.openId;
                        return [4 /*yield*/, activityconfigService.getActivityListByOpenId(openId, context.data)];
                    case 1:
                        result = _c.sent();
                        if (result) {
                            result.list = result.list.map(function (item) {
                                return __assign(__assign({}, item), { activityId: item._id });
                            });
                            return [2 /*return*/, sdk_1.resultsModel.success(result)];
                        }
                        return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '查询活动列表失败')];
                }
            });
        });
    };
    /**
     *  活动详情
     */
    ActivityController.prototype.getActivityDetail = function (context, _a, _b) {
        var activityconfigService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var activityId, result, _c, prizeConfig, baseConfig, prizes, activityInfo;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        activityId = context.data.activityId;
                        return [4 /*yield*/, activityconfigService.getActivityInfoByActivityId(activityId)];
                    case 1:
                        result = _d.sent();
                        if (!result)
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.PARAMS_ERROR, '当前活动不存在')];
                        _c = result || {}, prizeConfig = _c.prizeConfig, baseConfig = _c.baseConfig;
                        prizes = activityconfigService.formatPrizeConfig(prizeConfig);
                        activityInfo = __assign(__assign({ activityId: activityId }, baseConfig), prizes);
                        return [2 /*return*/, sdk_1.resultsModel.success(activityInfo)];
                }
            });
        });
    };
    /**
     *  删除活动
     */
    ActivityController.prototype.delActivity = function (context, _a, _b) {
        var activityconfigService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var activityId, result, deleteSuccess;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        activityId = context.data.activityId;
                        return [4 /*yield*/, activityconfigService.deleteActivityByActivityId(activityId)];
                    case 1:
                        result = _c.sent();
                        deleteSuccess = result === 0 || result;
                        if (deleteSuccess) {
                            return [2 /*return*/, sdk_1.resultsModel.success(true)];
                        }
                        else {
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '删除活动失败')];
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    __decorate([
        decorator_1.services([service_1.ActivityconfigService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], ActivityController.prototype, "getActivityList", null);
    __decorate([
        decorator_1.paramsCheck(['activityId']),
        decorator_1.services([service_1.ActivityconfigService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], ActivityController.prototype, "getActivityDetail", null);
    __decorate([
        decorator_1.paramsCheck(['activityId']),
        decorator_1.services([service_1.ActivityconfigService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], ActivityController.prototype, "delActivity", null);
    return ActivityController;
}());
exports.default = ActivityController;
//# sourceMappingURL=activity.controller.js.map