/**
 * 中奖名单 及导出中奖名单
 */

const RankopenprizeService = require('../service/rankopenprize.service');
const ResultsModel = require('../utils/results.model');
const { formatTime } = require("../utils/utils");
const {
    CODE_TYPES, EIGHT_HOURS
} = require('../utils/constants');
const xlsx = require('node-xlsx');
//奖池类型
const prizePoolType = {
    "1": "排行榜奖励",
    "2": "兑换奖品",
    "3": "大转盘奖品",
    "4": "其他奖励"
};
//发货状态
const shipMsg = {
    "1": "未填地址",
    "2": "未发货",
    "3": "已发货",
};

const prizeKind = {
    "1": "优惠券",
    "2": "权益",
    "3": "实物",
}


let resultsModel = new ResultsModel();

// 活动中奖名单
const findWinnerInfoList = async (context) => {
    let {
        activityId,
        pageNo, pageSize
    } = context.data;
    if (!activityId) {
        return resultsModel.error(CODE_TYPES.PARAMS_ERROR, `缺少activityId`);
    }
    if (!activityId) {
        return resultsModel.error(CODE_TYPES.PARAMS_ERROR, `缺少activityId`);
    }
    try {
        let rankopenprizeService = new RankopenprizeService(context);
        let total = await rankopenprizeService.getAwardslistCount(activityId);
        console.log("totle=========", total);
        let awardslist = [];
        let awardMore = await rankopenprizeService.getAwardslistByActivityId(
            activityId,
            pageSize,
            pageNo
        );
        awardslist = awardslist.concat(awardMore);
        // console.log('awardslist>>>>', awardslist)
        // awardslist = await rankopenprizeService.getAwardslistByActivityId(
        //   activityId,
        // );
        // console.log(`awardslist:》》》 ${JSON.stringify(awardslist)}《《《`);
        awardslist.map((item) => {
            let ad = item.province + item.city + item.area + item.addressDetail, type0 = item.type;
            item.prizeId = item._id;
            item.createTime = formatTime(new Date(item.createTime + EIGHT_HOURS)) || "";
            item.receiveTime = item.receiveTime ? formatTime(new Date(item.receiveTime + EIGHT_HOURS)) : '未填';
            item.prizeDataType = prizePoolType[item.prizeDataType];
            item.type = prizeKind[item.type];
            item.receiveName = type0 == 3 ? (item.receiveName || "未填") : '/';
            item.phone = type0 == 3 ? (item.phone || "未填") : '/';
            item.address = type0 == 3 ? (item.province ? ad : "未填") : '/';
            item.shipStatus = type0 == 3 ? (shipMsg[item.shipStatus]) : '/';
            item.shipCompany = type0 == 3 ? (item.shipCompany || '/') : '/';
            item.shipNum = type0 == 3 ? (item.shipNum || '/') : '/';
        })
        // console.log(`xlsxData: ${JSON.stringify(xlsxData)}`);

        return resultsModel.success({ list: awardslist, total });
    } catch (e) {
        console.log("上传文件出错", e);
        // 打印日志
        return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, `查看结果错误`);
    }
};
// 导出活动中奖名单
const exportAwardsList = async (context) => {
    let {
        cloud
    } = context;
    let {
        activityId,
        title
    } = context.data;
    if (!activityId) {
        return resultsModel.error(CODE_TYPES.PARAMS_ERROR, `缺少activityId`);
    }
    if (!title) {
        return resultsModel.error(CODE_TYPES.PARAMS_ERROR, `缺少title`);
    }
    let rankopenprizeService = new RankopenprizeService(context);
    // 获取活动中奖列表
    let awardslist = await rankopenprizeService.getAwardslistByActivityId(activityId);
    console.log(`awardslist: ${JSON.stringify(awardslist)}`);
    if (awardslist.length > 0) {
        let xlsxData = [
            [
                "序列",
                "奖品编号",
                "中奖时间",
                "地址填写时间",
                "用户昵称",
                "发奖来源",
                "奖品类型",
                "中奖名称",
                "收货人",
                "手机号",
                "省",
                "市",
                "区",
                "详细地址",
                "发货状态",
                "物流公司",
                "物流单号"
            ],
        ];
        awardslist.forEach((v, index, arr) => {
            xlsxData.push([
                index + 1,
                v._id,
                // 中奖时间-填写地址时间
                v.createTime ? formatTime(new Date(v.createTime + EIGHT_HOURS)) : "",
                v.type == 1 ? "/" : v.receiveTime ? formatTime(new Date(v.receiveTime + EIGHT_HOURS)) : "未填",
                v.userNick || "/",
                prizePoolType[v.prizeDataType],
                prizeKind[v.type],
                v.name || "",
                v.type == 1 ? "/" : v.receiveName || "",
                v.type == 1 ? "/" : v.phone || "未填",
                v.type == 1 ? "/" : (v.province ? v.province + v.city + v.area + v.addressDetail : "未填"),
                v.type == 1 ? "/" : shipMsg[v.shipStatus],
                v.type == 1 ? "/" : v.shipCompany || "/",
                v.type == 1 ? "/" : v.shipNum || "/",
            ]);
        });
        let buffer = xlsx.build([{
            name: title + new Date().getTime(),
            data: xlsxData
        }]);
        console.log(`xlsxData: ${JSON.stringify(xlsxData)}`);
        try {
            let result = await cloud.file.uploadFile({
                fileContent: buffer,
                fileName: title + new Date().getTime() + '.xlsx'
            });
            // result.url 需进行处理
            if (result.url) {
                result.url = result.url.replace('http', 'https').replace('-internal', '');
            }
            return resultsModel.success(result);
        } catch (e) {
            console.log('上传文件出错', e);
            // 打印日志
            return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, `上传文件错误`);
        }
    } else {
        return resultsModel.success(false);
    }
};
//-------------------start--------------------------------------------------
//《条件搜索》 导出活动中奖名单
const exportAwardsInfoBySearch = async (context) => {
    /******VV */
    let { cloud } = context;
    let { activityId, title, prizeId, userId: userNick, timeStart, timeEnd, shipStatus, prizeType, prizeDataType } = context.data;
    if (!activityId) {
        return resultsModel.error(CODE_TYPES.PARAMS_ERROR, `缺少activityId`);
    }
    if (!title) {
        return resultsModel.error(CODE_TYPES.PARAMS_ERROR, `缺少title`);
    }
    console.log("prizeId=====", prizeId);
    if (!prizeId && !userNick && !timeStart && !timeEnd && !shipStatus && !prizeType && !prizeDataType) {
        return resultsModel.error(CODE_TYPES.PARAMS_ERROR, `未填写筛选信息`);
    }
    console.log("activityId--1--", activityId, "prizeId--1-", prizeId, "userNick--1-", userNick, "timeStart--1-", timeStart, "timeEnd--1-", timeEnd);

    /*******/
    let rankopenprizeService = new RankopenprizeService(context);
    // 获取活动中奖列表
    let total = await rankopenprizeService.getTotalObjectCount(
        activityId,
        prizeId,
        userNick,
        timeStart,
        timeEnd,
        shipStatus,
        prizeType,
        prizeDataType);
    let awardslist = [];
    //导出中奖名单的pagesize和pageNo
    let pageSize0 = 500;
    let pageNo = 1;
    if (total > pageSize0) {
        let totalPage = Math.ceil(total / pageSize0);
        for (let i = 1; i <= totalPage; i++) {
            pageNo = i;
            let awardMore = await rankopenprizeService.getUserPrizeByActivityId(
                activityId,
                pageNo,
                pageSize0,
                prizeId,
                userNick,
                timeStart,
                timeEnd,
                shipStatus,
                prizeType,
                prizeDataType
            );
            awardslist = awardslist.concat(awardMore);
        }
    } else {
        awardslist = await rankopenprizeService.getUserPrizeByActivityId(
            activityId,
            pageNo,
            total,
            prizeId,
            userNick,
            timeStart,
            timeEnd,
            shipStatus,
            prizeType,
            prizeDataType
        );
    }
    console.log(`awardslist:》》》 ${JSON.stringify(awardslist)}《《《`);
    if (awardslist.length > 0) {
        let xlsxData = [
            [
                "序列",
                "奖品编号",
                "中奖时间",
                "地址填写时间",
                "用户昵称",
                "发奖来源",
                "奖品类型",
                "中奖名称",
                "收货人",
                "手机号",
                "省",
                "市",
                "区",
                "详细地址",
                "发货状态",
                "物流公司",
                "物流单号"
            ],
        ];
        awardslist.forEach((v, index, arr) => {
            xlsxData.push([
                index + 1,
                v._id,
                //中奖时间-填写地址时间
                v.createTime ? formatTime(new Date(v.createTime + EIGHT_HOURS)) : "",
                v.type == 1 ? "/" : v.receiveTime ? formatTime(new Date(v.receiveTime + EIGHT_HOURS)) : "未填",
                v.userNick || "/",
                prizePoolType[v.prizeDataType],
                prizeKind[v.type],
                v.name || "",
                v.type == 1 ? "/" : v.receiveName || "",
                v.type == 1 ? "/" : v.phone || "未填",
                v.type == 1 ? "/" : (v.province ? v.province + v.city + v.area + v.addressDetail : "未填"),
                v.type == 1 ? "/" : shipMsg[v.shipStatus],
                v.type == 1 ? "/" : v.shipCompany || "/",
                v.type == 1 ? "/" : v.shipNum || "/",
            ]);
        });
        let buffer = xlsx.build([
            {
                name: title + new Date().getTime(),
                data: xlsxData,
            },
        ]);
        try {
            let result = await cloud.file.uploadFile({
                fileContent: buffer,
                fileName: title + new Date().getTime() + ".xlsx",
            });
            // result.url 需进行处理
            if (result.url) {
                result.url = result.url.replace("http", "https").replace("-internal", "");
            }
            return resultsModel.success(result);
        } catch (e) {
            console.log("上传文件出错", e);
            // 打印日志
            return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, `上传文件错误`);
        }
    } else {
        return resultsModel.success(false)
    }
};

//筛选中奖名单
const findWinnerInfoListBySearch = async (context) => {
    let { cloud } = context;
    let { activityId, title, pageNo, pageSize, prizeId, userId: userNick, timeStart, timeEnd, shipStatus, prizeType, prizeDataType } = context.data;
    console.log('data>>>>>', context.data)
    if (!activityId) {
        return resultsModel.error(CODE_TYPES.PARAMS_ERROR, `缺少activityId`);
    }
    if (!title) {
        return resultsModel.error(CODE_TYPES.PARAMS_ERROR, `缺少title`);
    }
    console.log("prizeId=====", prizeId);
    if (!prizeId && !userNick && !timeStart && !timeEnd && !shipStatus && !prizeType && !prizeDataType) {
        return resultsModel.error(CODE_TYPES.PARAMS_ERROR, `未填写筛选信息`);
    }
    try {
        let rankopenprizeService = new RankopenprizeService(context);
        console.log("activityId----", activityId, "prizeId---", prizeId, "userNick---", userNick, "timeStart---", timeStart, "timeEnd---", timeEnd, shipStatus);
        // 获取活动中奖列表
        let total = await rankopenprizeService.getTotalObjectCount(activityId, prizeId, userNick, timeStart, timeEnd, shipStatus, prizeType, prizeDataType);
        console.log("totle=========", total);
        let awardslist = [];
        if (total > 10) {
            let totalPage = Math.ceil(total / pageSize);
            let awardMore = await rankopenprizeService.getUserPrizeByActivityId(
                activityId,
                pageNo,
                pageSize,
                prizeId,
                userNick,
                timeStart,
                timeEnd,
                shipStatus,
                prizeType,
                prizeDataType
            );
            // console.list()
            awardslist = awardslist.concat(awardMore);
        } else {
            awardslist = await rankopenprizeService.getUserPrizeByActivityId(
                activityId,
                pageNo,
                pageSize,
                prizeId,
                userNick,
                timeStart,
                timeEnd,
                shipStatus,
                prizeType,
                prizeDataType
            );
            console.log('awardslist>>>>', awardslist)
        }
        console.log(`awardslist:》》》 ${JSON.stringify(awardslist)}《《《`);
        awardslist.map((item) => {
            let ad = item.province + item.city + item.area + item.addressDetail, type0 = item.type;
            item.prizeId = item._id;
            item.createTime = formatTime(new Date(item.createTime + EIGHT_HOURS)) || "";
            item.receiveTime = item.receiveTime ? formatTime(new Date(item.receiveTime + EIGHT_HOURS)) : '未填';
            item.prizeDataType = prizePoolType[item.prizeDataType];
            item.type = prizeKind[item.type];
            item.receiveName = type0 == 3 ? (item.receiveName || "未填") : '/';
            item.phone = type0 == 3 ? (item.phone || "未填") : '/';
            item.address = type0 == 3 ? (item.province ? ad : "未填") : '/';
            item.shipStatus = type0 == 3 ? (shipMsg[item.shipStatus]) : '/';
            item.shipCompany = type0 == 3 ? (item.shipCompany || '/') : '/';
            item.shipNum = type0 == 3 ? (item.shipNum || '/') : '/';
        })
        // console.log(`xlsxData: ${JSON.stringify(xlsxData)}`);

        return resultsModel.success({ list: awardslist, total });
    } catch (e) {
        console.log("上传文件出错", e);
        // 打印日志
        return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, `查看结果错误`);
    }
};
/*
[{
  "data": [
    ["序列", "中奖时间", "收获地址", "邮编"],
    ["1","creatTime","XXX","XXX"]
  ],
  "name": "测试活动LSS1594797305510"
}]
*/
//导入发货状态信息
const downloadFile = async (context) => {
    const cloud = context.cloud;
    //获取活动id
    const { activityId, fileName } = context.data;
    console.log("====--=-=-=-=-", fileName);
    //-----------
    let fileId = fileName;
    let result, total = 0;
    try {
        result = await cloud.file.downloadFile({ fileId })
        const sheets = xlsx.parse(result);
        //接口调用
        let { data } = sheets[0];
        if (data[1].length == 3) {
            for (let i = 1; i < data.length; i++) {
                //activityId, prizeId, shipCompany, shipNum, 
                let rankopenprizeService = new RankopenprizeService(context);
                let prizeId = data[i][0];
                let shipCompany = data[i][1];
                let shipNum = data[i][2];
                let result2 = await rankopenprizeService.setUserShipStatus(activityId, prizeId, shipCompany, shipNum);
                total += result2;
                console.log(">>>");
            }
            return resultsModel.success({ total, data });
        }
        else {
            return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, "导入文件格式错误");
        }
    } catch (e) {
        console.log("e", e);
        return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, "导入文件出现错误");
    }
};

//-------------------end--------------------------------------------------

module.exports = {
    findWinnerInfoList,
    exportAwardsList,
    //搜索条件导出中奖名单
    findWinnerInfoListBySearch,
    exportAwardsInfoBySearch,
    downloadFile
};