const ActivitySellerService = require("../service/activityseller.service");
const { CODE_TYPES, TEMPLATE_INFO } = require("../utils/constants");
const ActivityTopService = require("../service/activitytop.service");
const ActivityInstanceService = require("../service/activityinstance.service");
const { loginfo } = require("../utils/utils");

const ResultsModel = require("../utils/results.model");

let resultsModel = new ResultsModel();

//保存授权信息//保存授权信息
module.exports = async (context) => {
  loginfo(context, "sellerInfo");
  let { openId, accessToken, appKey, userNick, appOwnerOpenId } = context;
  let ActivitySeller = new ActivitySellerService(context);
  try {
    let isPrimaryAccount = userNick.indexOf(':')  === -1;
    console.log(userNick, isPrimaryAccount, "userNick------");
    if (!isPrimaryAccount) {
      let userNickArr = userNick.split(":");
      let sellerInfo = await ActivitySeller.getSellerInfoByUserNick(
        userNickArr[0]
      );
      console.log(sellerInfo, "seller----info------");
      if (sellerInfo) {
        accessToken = sellerInfo.accessToken;
      }
    }
    let hasResult = await ActivitySeller.findSellerInfo(context.openId);
    if (hasResult && hasResult[0]) {
      await ActivitySeller.updateSellerInfo(context.openId, {
        accessToken,
      });
      return resultsModel.success(true);
    } else {
      try {
        let result = await ActivitySeller.saveSellerInfo({
          accessToken,
          openId,
          appKey,
          userNick,
          appOwnerOpenId,
        });
        return resultsModel.success(result);
      } catch (e) {
        console.log(e, "保存授权信息失败");
        return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, "保存授权信息失败");
      }
    }
  } catch (e) {
    console.log(e, "获取授权信息失败");
    return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, "获取授权信息失败");
  }
};
