import { passUrlList } from "./helper";

// 正整数
export const validatePositiveInteger = number => /^[1-9]\d*$/.test(number);

// 整数
export const validateInteger = number => /^-?\d*$/.test(number);

// 判断是否为数字
export const isNumber = val => {

  var regPos = /^\d+(\.\d+)?$/; //非负浮点数
  var regNeg = /^(-(([0-9]+\.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*\.[0-9]+)|([0-9]*[1-9][0-9]*)))$/; //负浮点数
  if (regPos.test(val) && regNeg.test(val)) {
    return true;
  } else {
    return false;
  }

}

/**
*
* 验证一定范围内数,支持整数或小数
* @param {*} number 
* @param {*} [ min, max ] 范围    [0,99]  [-Infinity, 0]  [999, Infinity]
* @param {number} [fixed=0] 小数位数  0时为整数
* @returns { boolean }
*/
export const validateRangeNumber = (number, [min, max] = [], fixed = 0) => {
  const pattern = new RegExp(`^-?[0-9]+(\\.[0-9]{0,${fixed}})?$`);

  if (min > max) {
    console.error('数字范围的最小值不能大于最大值');
    return;
  }
  if (!pattern.test(number) || number === '') return false;

  if (number < min || number > max) return false;

  return true;
}



// 配置验证


// 排名表格验证
export const rankTableValidator = (rule, value, callback, source, options) => {

  if (!value.length) return new Error('请配置至少一项奖品配置');

  // rank字段不存在或为0
  if (value.some(v => !v.rank)) return new Error('名次配置错误, 请检查');
  if (value.some(v => !v.name)) return new Error('名次配置错误, 请检查');
  const rankArr = (value.map(v => v.rank.split('-')));


  // 判断排名连续
  let validInfo = {
    status: true,
    message: '名次索引必须连续, 请检查'
  };

  rankArr.forEach((rank, i) => {
    if (i === 0) return;
    let lastRank = rankArr[i - 1][rankArr[i - 1].length - 1];
    let curRank = rank[0];
    if (curRank - lastRank === 0) {
      validInfo = {
        status: false,
        message: '请勿对重复的名次添加奖品'
      }
    }
    if (validInfo.status && (curRank - lastRank !== 1)) {
      validInfo.status = false;
    }
  })
  if (!validInfo.status) return new Error(validInfo.message);
  return callback()
}

// 活动时间验证
export const rankTimeValidator = (rule, value, callback, source, options) => {
  if (value && value.length == 2) {
    const [startTime, endTime] = value;
    if (!startTime || !endTime) {
      return new Error('请选择完整活动时间');
    }
    // 活动未开始 | 新建活动
    if (+source.originalStartTime > Date.now() || !source.originalStartTime) {
      if (new Date().getTime() > startTime) {
        return new Error('活动开始时间需大于当前时间');
      }
      if (endTime === startTime) {
        return new Error('活动开始时间不能等于结束时间');
      }
      if (startTime > endTime) {
        return new Error('活动开始时间不能大于结束时间');
      }
    }
  }
  return callback();
}

// 判断网站域名
export const urlCheck = (rule, value, callback, source, options) => {
  if (!value) return new Error('请配置链接');
  if (!value.startsWith("http://") && !value.startsWith("https://")) return new Error('请配置链接');

  let passUrl = false;
  passUrlList.some((i) => {
    if (~value.indexOf(i)) {
      passUrl = true
      return true;
    }
  });
  if (!passUrl) {
    return new Error('域名校验不通过');
  }
  return callback();

}

// 判断是否含有小数点
export const isDot = (num) => {
  var result = (num.toString()).indexOf(".");
  if (result != -1) {
    return false
  } else {
    return true
  }
}