
import {
  findWinnerInfoList,
  uploadDataCreateFile,
  // 通过搜索条件筛选中奖名单
  exportAwardsInfoBySearch,
  findWinnerInfoListBySearch
} from "/api";
import { appId } from "/config";
import { setClipboard } from "/utils";
//每页的展示数量
const PageInfo = {
  PAGE_SIZE: 100,
  PAGE_NO: 1
}
Component({
  mixins: [],
  data: {
    PageInfo,
    tabs: [{
      tab: '0608-0712',
      key: 111
    }, {
      tab: '03308-0712',
      key: 43
    }, {
      tab: '064548-0712',
      key: 435
    }, {
      tab: '0608-0712',
      key: 436545
    }, {
      tab: '0608-0712',
      key: 65
    }, {
      tab: '0608-0712',
      key: 11561
    }, {
      tab: '0608-0712',
      key: 13311
    }, {
      tab: '0608-0712',
      key: 145611
    }, {
      tab: '0608-0712',
      key: 1178761
    }],
    dataSource: [],
    columns: [
      { title: '奖品编号', prop: 'prizeId' },// prizeId为awards_info中的_id
      { title: '发奖时间', prop: 'createTime' },
      { title: '填地址时间', prop: 'receiveTime' },
      { title: '用户昵称', prop: 'userNick' },
      { title: '发奖来源', prop: 'prizeDataType' },
      { title: '奖品类型', prop: 'type' },
      { title: '奖品名', prop: 'name' },
      { title: '收货人', prop: 'receiveName' },
      { title: '联系方式', prop: 'phone' },
      /* 注：需要在接口里将 省+市+区+详细  拼写起来*/
      { title: '收货地址', prop: 'address' },// { title: '收货地址', prop: 'address', width: 240 }
      { title: '物流状态', prop: 'shipStatus' },
      { title: '物流公司', prop: 'shipCompany' },
      { title: '物流单号', prop: 'shipNum' }
    ],
    // pageInfo: {
    //   pageNo: 1,
    //   pageSize: 100,
    //   total: 0
    // },
    // 《条件搜索》start显示中奖名单搜索条件
    list: [],
    prizeId: "",
    userId: "",
    startT: "",
    endT: "",
    shipStatus: "",
    timeRange: [],
    prizeType: "",
    prizeDataType: "",
    showShip: false,
    winactivityId: "",
    pageNo: PageInfo.PAGE_NO,
    pageSize: PageInfo.PAGE_SIZE,
    total: 0,
    // end
    //需要筛选查询时改为true
    isSearch: true
  },
  props: {
    onClose: () => { },
    selectedItem: {},
  },
  didMount() {
    if (!this.data.isSearch) {
      this.loadWinnerList();
    }

  },
  didUpdate() { },
  didUnmount() { },
  methods: {
    // start《条件搜索》初始化数据更新
    initData() {
      this.setData({
        list: [],
        prizeId: "",
        userId: "",
        startT: "",
        endT: "",
        timeRange: [],
        shipStatus: "",
        prizeType: "",
        prizeDataType: "",
        pageNo: PageInfo.PAGE_NO,
        pageSize: PageInfo.PAGE_SIZE,
        total: 0,
      });
    },
    //加载中奖名单
    async loadWinnerList() {
      let { pageNo, pageSize } = this.data;
      let { activityId } = this.props.selectedItem;
      const { data, success } = await findWinnerInfoList({ activityId, pageNo, pageSize });
      console.log('data>>>>>', data);
      if (success) {
        this.setData({
          list: data.list,
          total: data.total
        });
      }

    },
    // end
    onCloseDialog() {
      this.initData();
      this.props.onClose && this.props.onClose();
    },
    async getWinnerList() {
      const { avtivityId } = this.props;
      const { data } = await findWinnerInfoList({
        avtivityId
      });
      this.setData({
        dataSource: data
      });
    },
    // 导出中奖名单
    async exportWinnerList(evt) {
      const { activityId, title } = this.props.selectedItem;
      const { type } = evt.target.dataset;
      my.showLoading({ content: "生成文件中..." });
      try {
        const { success, data, message } = await uploadDataCreateFile({
          activityId,
          title
        });
        my.hideLoading();

        if (success) {
          await setClipboard({ text: data.url.replace(/amp;/g, "") });
          my.showToast({
            type: 'success',
            content: '下载链接复制成功,请在浏览器中打开下载'
          });
          this.setData({
            exportDialogVisible: true,
            exportUrl: data.url.replace(/amp;/g, "")
          });
        } else {
          my.showToast({
            type: "fail",
            content: message,
          });
        }
      } catch (error) {
        my.hideLoading();
        console.log(error, "exportList-error");
      }
    },

    // 《条件搜索》 导出中奖名单

    timeExchange(time) {
      console.log("time==", time);
      let a = time ? new Date(time) : "";
      let times = a ? a.getTime() : "";
      return times;
    },
    async exportWinnerListBySearch(evt) {
      const { activityId, title } = this.props.selectedItem;
      let { prizeId, userId, startT, endT, shipStatus, pageNo, pageSize, prizeType, prizeDataType } = this.data;
      let timeStart = this.timeExchange(startT);
      let timeEnd = this.timeExchange(endT);
      if (prizeId || userId || (timeStart && timeEnd) || shipStatus || prizeType || prizeDataType) {
        try {
          console.log("导出名单数据接口");
          const { success, data, message } = await exportAwardsInfoBySearch({
            activityId,
            pageNo, pageSize,
            title,
            prizeId,
            userId,
            timeStart,
            timeEnd,
            shipStatus,
            prizeType,
            prizeDataType
          });
          if (success) {
            if (!data) {
              my.showToast({
                type: 'fail',
                content: '没有符合条件的订单！'
              });
            }
            else {
              console.log("导出中奖名单");
              my.setClipboard({
                text: data.url.replace(/amp;/g, ''),
                success(res) {
                  my.showToast({
                    type: 'success',
                    content: '下载链接复制成功,请在浏览器中打开下载'
                  });
                }
              });
            }
          } else {
            my.showToast({
              type: 'fail',
              content: message
            });
          }
        } catch (error) {
          my.hideLoading();
          console.log('exportList-error', error);
        }
      }
      else {
        my.showToast({
          type: "fail",
          content: "请填写至少一个筛选信息"
        });
      }
    },

    // 《条件搜索》导入发货信息
    onChangeUpLoad() {
      const { activityId, title } = this.props.selectedItem;
      this.setData({
        showShip: true,
        winactivityId: activityId
      });
    },
    // 《条件搜索》关闭导入发货窗口
    onCloseShip() {
      this.setData({
        showShip: false,
      });
    },
    // 《条件搜索》搜索
    async onChangeSearch() {
      const { activityId, title } = this.props.selectedItem;
      let { prizeId, userId, startT, endT, pageNo, pageSize, shipStatus, prizeType, prizeDataType } = this.data;
      let timeStart = this.timeExchange(startT);
      let timeEnd = this.timeExchange(endT);
      console.log(prizeId, userId, timeStart, timeEnd, pageNo, pageSize, shipStatus, prizeType, prizeDataType);
      if (prizeId || userId || (timeStart && timeEnd) || shipStatus === 0 || shipStatus || prizeType || prizeDataType) {
        let rewardList = await findWinnerInfoListBySearch({ activityId, pageNo, pageSize, title, prizeId, userId, timeStart, timeEnd, shipStatus, prizeType, prizeDataType });
        if (rewardList.data.list.length == 0) {
          this.setData({
            list: [],
            total: 0
          }); 0;
          my.showToast({
            type: "fail",
            content: "没有符合条件的订单！"
          });
        } else {
          console.log("rewardList==", rewardList);
          this.setData({
            list: rewardList.data.list,
            total: rewardList.data.total
          });
        }
      }
      else {
        my.showToast({
          type: "fail",
          content: "请填写至少一个筛选信息"
        });
      }
    },
    // 《条件搜索》按照时间搜索
    onChangeTime(e) {
      console.log("时间搜索e", e);
      const [startTime, endTime] = e.detail.value;
      this.setData({
        startT: startTime || "",
        endT: endTime || "",
        timeRange: [startTime, endTime],
        pageNo: PageInfo.PAGE_NO,
        pageSize: PageInfo.PAGE_SIZE,
        total: 0,
      });
      console.log("this.data.timeRange==", this.data.timeRange, this.data.startT, this.data.endT);
    },
    // 《条件搜索》输入框查找信息
    onInputChange(e) {
      let { type } = e.currentTarget.dataset;
      let { value } = e.detail;
      this.setData({
        [type + "Id"]: value,
        pageNo: PageInfo.PAGE_NO,
        pageSize: PageInfo.PAGE_SIZE,
        total: 0,
      });
      console.log("this.data.prizeId===", this.data.prizeId, "this.data.userId===", this.data.userId);
    },
    // 《条件搜索》发货状态筛选
    onSelectShipStatus(e) {
      console.log('筛选发货状态e>>>', e);
      this.setData({
        shipStatus: e.detail.value,
        pageNo: PageInfo.PAGE_NO,
        pageSize: PageInfo.PAGE_SIZE,
        total: 0,
      });
    },
    // 《条件搜索》奖品类型筛选
    onSelectPrizeType(e) {
      let { type } = e.target.dataset;
      console.log('筛选奖品类型e>>>', e);
      this.setData({
        [type]: e.detail.value,
        pageNo: PageInfo.PAGE_NO,
        pageSize: PageInfo.PAGE_SIZE,
        total: 0,
      });
      console.log("type", this.data[type]);
    },
    // 《条件搜索》更换页码时调用接口
    onChangePageNo(e) {
      this.setData({
        pageNo: e.detail.value
      });
      if (this.data.isSearch) {
        this.onChangeSearch();
      } else {
        this.loadWinnerList();
      }
    }
  },
});
