import React, { useEffect, useState, useRef, createRef } from 'react'
import { View } from '@tarojs/components'
import { useDidShow, useRouter, useDidHide, getApp } from '@tarojs/taro'
import API from '@/api'
import { useLogin, useLoginFromShare } from '@/hooks/useLogin'
import { useActivityInfoModel, useLoginInfoModel } from '@/store'
import { prizeList, BARRAGE_LIST, levelList } from '@/mock'
import { dateFormatter } from 'tbcc-sdk-ts/lib/utils/index'
import { navigateTo } from 'tbcc-sdk-ts/lib/core/tb'


import styles from './comsTest.module.less'

import {useAudio} from '@/hooks/useAudio'

import { CLOUD_OBJ, BGMUSIC_URL } from '@/const'

import ContainerFit from '@/components/_base/ContainerFit/ContainerFit'

import ContainerScroll from '@/components/_base/ContainerScroll/ContainerScroll'

import ScrollXView from '@/components/_tb_comps/ScrollXView/ScrollXView'

import SwiperView from '@/components/_tb_comps/SwiperView/SwiperView'

import RotateWheel from '@/components/_tb_comps/RotateWheel/RotateWheel'

import RankTitle from '@/components/_tb_comps/Rank/RankTitle/RankTitle'

import RankList from '@/components/_tb_comps/Rank/RankList/RankList'

import Demo from '@/components/_tb_comps/_Progress/demo' 

import Countdown from '@/components/_tb_comps/CountDown/CountDown'

import JackpotModal from '@/components/_tb_modal/JackpotModal'

import { VerticalBarrage } from '@/components/_tb_comps/Barrage'


const rotateConfig = {
    bg: 'https://yun.duiba.com.cn/spark/assets/8b6e920ffd09fab8f9ac2de09f9154879f4d0607.png',
    ratio: 0.65,
    radius: 300,
    circles: 4,
    divideNum: 8,
    duration: 5000,
    timeFunction:'ease-in-out',
    nodeInfo:{
        width:100,
        height:100
    },
    imgInfo:{width:80,height:80},
    showWay:'negative',//positive/negative
    isShowPrizeName:true,
    prizeNameWidthRatio:1.2
}

const SCROLLXVIEW_CONFIG = {
    prizeList: [], 
    containerWidth : 200, 
    containerHeight : 200,
    imgWidth:120,
    imgHeight:120,
    isShowPrizeName:true,
    prizeInCenterNum:3,
    marginRight:26,
    backgroundColor:'#E7E7EF',
    backgroundImage:''
}

const swiper_config = {
    easingFunction:`linear`,
    circular:true,
    autoplay:true,
    vertical:false,
    duration:1000,
    interval:1500,
    disableTouch:false,
    swiperGroup:{width:300,height:400},
    swiperContent:{width:300,height:400},
    imgContent:{width:200,height:200},
    textContent:{width:300,height:60}
}

const prizeItem = {
    id: "6115fc6a3075d9bde4b16a53",
    image: "https://img.alicdn.com/imgextra/i4/353042333/O1CN012k7gbk1T6YigovFNu_!!353042333-0-isvtu.jpg",
    type: 2,
    name: '测试i奖品'
}

export default function ComsTest(props) {

    /* 背景音乐 */
  const {playAudio,musicUrl,setOpenStatus,openStatus} = useAudio(BGMUSIC_URL.MUSIC,true)

  const [endTime, setEndTime] = useState('')

  const [prizeModalVisible,setPrizeModalVisible] = useState(false)

  const containerRef = createRef()

  useEffect(() => {
      const _endTime = dateFormatter(Date.now() + 10 * 24 * 60 * 60 * 1000,'yyyy-MM-dd hh:mm:ss')
      setEndTime(_endTime)
  })
  const playCurrentAudio = () => {
    setOpenStatus(!openStatus)
  }

    return(
        <>
            <ContainerScroll ref={containerRef}>
                <View className={styles['scroll-view']}>
                    <View className={styles['comp-title']}>滑动组件</View>
                    <ScrollXView prizeList={prizeList} />
                </View>
                <View className={styles['comp-view']}>
                    <View className={styles['comp-title']}>swiper左右滑动</View>
                    <SwiperView swiperList={prizeList} />
                </View>
                <View className={styles['comp-view']}>
                    <View className={styles['comp-title']}>大转盘</View>
                    <RotateWheel />
                </View>
                <View className={styles['comp-view']}>
                    <View className={styles['comp-title']}>进度条</View>
                    <Demo levelList={levelList} />
                </View>
                <View className={styles['comp-view']}>
                    <View className={styles['comp-title']}>排行榜</View>
                    <RankTitle />
                    <RankList />
                </View>
                <View className={styles['comp-view']}>
                    <View className={styles['comp-title']}>倒计时</View>
                    {endTime && <Countdown targetTime={endTime} showDay={true} />}
                </View>
                <View className={styles['comp-view']}>
                    <View className={styles['comp-title']}>音频hooks</View>
                    <View className={styles['view']} onTap={playCurrentAudio}>play audio</View>
                </View>
                <View className={styles['comp-view']} style={{ marginBottom: '0.5rem', width: '4rem'}}>
                    <View className={styles['comp-title']}>竖向弹幕</View>
                    <VerticalBarrage dataList={BARRAGE_LIST} />
                </View>

                <View onClick={() => containerRef.current?.scrollFixTop(600)} className={styles['btn-one']}>滚动指定位置</View>

                <View onClick={() => setPrizeModalVisible(true)} className={styles['btn-two']}>中奖弹窗</View>

                <View onClick={() => navigateTo('/pages/packageGood/browseGoods/browseGoods?itemIds=617724147979,617724563528,617300295119')} className={styles['btn-three']}>浏览商品</View>

                <View onClick={() => navigateTo('/pages/packageGood/collectGoods/collectGoods?itemIds=617724147979,617724563528,617300295119')} className={styles['btn-four']}>收藏商品</View>

                <View onClick={() => navigateTo('/pages/packageGood/orderGoods/orderGoods?itemIds=617724147979,617724563528,617300295119')} className={styles['btn-five']}>下单商品</View>

                <View onClick={() => navigateTo('/pages/packageGood/cartGoods/cartGoods?itemIds=617724147979,617724563528,617300295119')} className={styles['btn-six']}>加购商品</View>
            </ContainerScroll>
            { prizeModalVisible && <JackpotModal prizeItem={prizeItem} onClose={() => setPrizeModalVisible(false)} />}
        </>
    )
}