import React, { useState } from 'react'
import { View, Text, Image } from '@tarojs/components'
import Modal from '@/components/_base/Modal/Modal'
import { useThrottle } from '@/hooks/useThrottle'
import useReceive from '@/hooks/useReceive'
import './JackpotModal.less'

const prizeItem = {
  image:'',
  name:'',
  type:'', // 奖品类型
  id:'', // 奖品id
  _id:'',
  ename:'', // 会员权益
  benefitType:'' // 会员权益
}

const JackpotModal = (props) => {
  const { receivePrize } = useReceive({ successMsg: '奖品发放成功，请前往我的奖品处进行使用', errorMsg: '奖品发放失败，请前往我的奖品处进行处理' })
  const { onClose, top = '50%', bg = '', width = 600, height = 700, receive = true, prizeItem={}, showMember=()=>{} } = props
  const [ memberModalVisible, setMemberModalVisible ] = useState(false)

  const handleClick = useThrottle(async() => {
    // 如果跳转我的奖品页面
    if(!receive) {
      onClose && onClose()
      return;
    }
    const callObj = {
      vipCallback:()=>{
        setMemberModalVisible(true)
      },
      updateCallback:()=>{},
      closeCallback:()=>{onClose()}
    }
    receivePrize(prizeItem,callObj);
  })

  // 入会弹窗
  const onAuthSuccess = async() => {
    setMemberModalVisible(false)
    handleClick()
  }
  const onAuthFail = () => {
    setMemberModalVisible(false)
  }
  const closeMemberModal = () => {
    setMemberModalVisible(false)
  }

  return (
    <>
      <Modal onClose={onClose} top={top}>
        <View className='jackpot_content' style={{ width: `${width / 100}rem`, height: `${height / 100}rem`, backgroundImage: `url(${bg})` }}>
          <View className='title_box'>
            <Text className='title'>恭喜您</Text>
          </View>
          <Text className='notify'>抽到了以下奖品</Text>
          <View className='gift_box'>
            <View className='gift'>
              <Image src={prizeItem?.image} />
            </View>
            <Text className='gift_name'>{prizeItem?.name}</Text>
          </View>
          <View className='btn' onTap={handleClick}>领取奖励</View>
          <Text className='hint'>奖品可在<Text className='hint_hot'>“我的奖品”</Text>中查看</Text>
        </View>
      </Modal>
      {
        <member-modal
          expend={memberModalVisible}
          onClose={() => closeMemberModal()}
          onAuthFail={onAuthFail}
          onAuthSuccess={onAuthSuccess}
        />
      }
    </>
  )
}

export default JackpotModal
