/** @format */

import { services, preCheck, registeInfos, preUpdate, checkParams } from '../decorator/common'
import { resultsModel } from '../sdk'
import { CommonStatService, CommonGrowtaskService } from '../service/common'
import { STAT_TYPE } from '../constants'
import { checkActivityTime, checkInviteId, checkHelpRecord, checkNewVip } from '../utils/common/check'
import { updateHelpRecord, updateVip } from '../utils/common/update'
import { getTask } from '../utils'

export default class Share {
  /**
   *  完成分享
   */
  @checkParams(['activityId', 'inviteId'])
  @registeInfos(['vipInfo'])
  @services([CommonGrowtaskService, CommonStatService])
  @preCheck([checkActivityTime, checkInviteId, checkNewVip, checkHelpRecord])
  @preUpdate([updateVip, updateHelpRecord])
  async doHelp(
    context: IContext<IParams>,
    { userInfo, activityInfo }: IControllerInfos,
    [growTaskService, statService]: [CommonGrowtaskService, CommonStatService],
    { inviteUserInfo }: IPreCheckData
  ) {
    // 如果邀请任务是每日的，则需要请求每日任务信息
    const task = await getTask(context, inviteUserInfo.openId)
    const result = await growTaskService.completeTask('invites', activityInfo, inviteUserInfo, task)

    statService.addStat(STAT_TYPE.INITE_SUCCESS, userInfo)

    return resultsModel.success(result)
  }
}
