import React, { useEffect, useState, useRef } from 'react'
import { View } from '@tarojs/components'
import { useDidShow, useRouter, useDidHide, getApp } from '@tarojs/taro'
import API from '@/api'
import { useLogin, useLoginFromShare } from '@/hooks/useLogin'
import { useActivityInfoModel, useLoginInfoModel } from '@/store'
import { prizeList, BARRAGE_LIST } from '@/mock'

import styles from './preComp.module.less'

import {useAudio} from '@/hooks/useAudio'

import {CLOUD_OBJ, BGMUSIC_URL} from '@/const'

import ContainerFit from '@/components/_base/ContainerFit/ContainerFit'

import ScrollXView from '@/components/_tb_comps/ScrollXView/ScrollXView'

import SwiperView from '@/components/_tb_comps/SwiperView/SwiperView'

import RotateWheel from '@/components/_tb_comps/RotateWheel/RotateWheel'

import RankTitle from '@/components/_tb_comps/Rank/RankTitle/RankTitle'

import RankList from '@/components/_tb_comps/Rank/RankList/RankList'

import Demo from '@/components/_tb_comps/_Progress/demo' 

import Countdown from '@/components/_tb_comps/CountDown/CountDown'

// import Demo from '@/components/_tb_comps/Rank/demo/index'

import JackpotModal from '@/components/_tb_modal/JackpotModal'


import { VerticalBarrage } from '@/components/_tb_comps/Barrage'


const rotateConfig = {
    bg: 'https://yun.duiba.com.cn/spark/assets/8b6e920ffd09fab8f9ac2de09f9154879f4d0607.png',
    ratio: 0.65,
    radius: 300,
    circles: 4,
    divideNum: 8,
    duration: 5000,
    timeFunction:'ease-in-out',
    nodeInfo:{
        width:100,
        height:100
    },
    imgInfo:{width:80,height:80},
    showWay:'negative',//positive/negative
    isShowPrizeName:true,
    prizeNameWidthRatio:1.2
}

const SCROLLXVIEW_CONFIG = {
prizeList: [], 
containerWidth : 200, 
containerHeight : 200,
imgWidth:120,
imgHeight:120,
isShowPrizeName:true,
prizeInCenterNum:3,
marginRight:26,
backgroundColor:'#E7E7EF',
backgroundImage:''
}

const swiper_config = {
    easingFunction:`linear`,
    circular:true,
    autoplay:true,
    vertical:false,
    duration:1000,
    interval:1500,
    disableTouch:false,
    swiperGroup:{width:300,height:400},
    swiperContent:{width:300,height:400},
    imgContent:{width:200,height:200},
    textContent:{width:300,height:60}
}
export default function PreComp(props) {

    /* 背景音乐 */
  const {playAudio,musicUrl,setOpenStatus,openStatus} = useAudio(BGMUSIC_URL.MUSIC,true)

  const playCurrentAudio = () => {
    setOpenStatus(!openStatus)
  }

    return(
        <ContainerFit hasFitPsd={true}>
            <View className={styles['scroll-view']}>
                {/* <ScrollXView prizeList={prizeList} /> */}
            </View>
            <View className={styles['comp-view']}>
                {/* 大转盘 */}
                {/* <RotateWheel /> */}
            </View>
            <View className={styles['comp-view']}>
                {/* swiper左右滑动 */}
                <SwiperView swiperList={prizeList} />
            </View>

            {/* 排行榜 进度条 */}
            {/* <Demo /> */}

            {/* 倒计时 */}
            <View 
                className={styles['view']} 
                style={{
                    marginTop:`${300/100}rem`
                }}
            >
                {/* <Countdown targetTime="2021-10-01 10:00:00" /> */}
                <View className={styles['view']} onTap={playCurrentAudio}>play audio</View>
            </View>

            {/* 竖向弹幕 */}
            {/* <VerticalBarrage dataList={BARRAGE_LIST} /> */}

        </ContainerFit>
    )
}