import { useCallback } from 'react'
import { checkIsMember } from 'tbcc-sdk-ts/lib/utils'
import tbccTs from 'tbcc-sdk-ts'
import { PRIZE_TYPE } from '@/config/myPrize.config'

const { getUserAddress } = tbccTs.tb

const useReceive = (config) => {
  const { receiveEnamePrize = () => { }, receiveObjectPrize = () => { } } = config
  // 积分
  const handleGetCredits = useCallback(async (id) => {
    // 判断是否为会员
    const isVip = await checkIsMember()
    console.log(isVip)
    if (!isVip) {
      return {
        message: '需加入会员才能领取成功哦',
        state: 'error',
        isVip:isVip
      }
    }
    const { success, data } = await receiveEnamePrize({ id })
    if (success && data) {
      return {
        message: '领取成功',
        state: 'success',
        isVip: true
      }
    }
  }, [checkIsMember, receiveEnamePrize])

  // 优惠券
  const handleGetEquity = useCallback(async (id) => {
    const { success, data } = await receiveEnamePrize({ id })
    if (success && data) {
      return {
        message: '领取成功',
        state: '领取成功',
        isVip: true
      }
    }
  }, [receiveEnamePrize])

  // 实物
  const handleReceiveObjectPrize = useCallback(async (params) => {
    let errorMessage = ''
    const { success, data } = await receiveObjectPrize(params).catch(res => {
      errorMessage = res && res.message
    }) || {}
    if (success && data) {
      return {
        message: '领取成功',
        state: 'success',
        isVip: true

      }
    } else {
      return {
        message: errorMessage,
        state: 'error',
        isVip: true
      }
    }
  }, [receiveObjectPrize])

  // 确认地址
  const handleChooseAddress = useCallback(async (id) => {
    let errorMessage = ''
    const userAddress = await getUserAddress().catch(err => {
      errorMessage = err && err.errorMessage
    })
    if (!userAddress) {
      return {
        message: errorMessage,
        state: 'error',
        isVip: true

      }
    }
    const { name, telNumber, provinceName, cityName, cityCode, countyName, detailInfo, streetName } = userAddress || {}
    const params = {
      name,
      phone: telNumber,
      addressDetail: detailInfo,
      cityCode,
      city: cityName,
      province: provinceName,
      area: countyName,
      streetName,
      id
    }

    const result = await my.confirm({
      title: '提示',
      content: '确认使用该收货地址：' + name + telNumber + userAddress.duibaAddress.address,
      confirmButtonText: '确定',
      cancelButtonText: '取消'
    })

    if (result.confirm) {
      return await handleReceiveObjectPrize(params)
    }
  }, [getUserAddress])

  // 导出的方法
  const exportFn = useCallback(async ({ type, prizeId }) => {
    // 领取优惠券
    if (type === PRIZE_TYPE.ENAME) return await handleGetEquity(prizeId)
    // 领取实物
    if (type === PRIZE_TYPE.OBJECT) return await handleChooseAddress(prizeId)
    // 领取积分
    if (type === PRIZE_TYPE.CREDITS) return await handleGetCredits(prizeId)
  }, [handleGetEquity, handleChooseAddress, handleGetCredits])

  return [exportFn]
}

export default useReceive
