import { View } from '@tarojs/components'
import { memo, useMemo, useCallback } from 'react'
import classnames from 'classnames'

import ProgressNode from './ProgressNode'
import styles from './index.module.less'

import {
  ProgressContext,
  ProgressGlobalConfig
} from './ProgressContext'

const Progress = memo(props => {
  const {
    levelList = [],
    currentValue = 0,
    className,
    maxLevel = ProgressGlobalConfig.maxLevel,
    width = ProgressGlobalConfig.width
  } = props

  const LevelList = useMemo(() => {
    return levelList
  }, levelList)

  // 合并全局配置
  const mergeConfigToDefault = useCallback(config => {
    return { ...ProgressGlobalConfig, ...config }
  }, [])

  /**
   * 过滤props
   * @param {*} props 过滤对象
   * @param {*} filterPropArr 需要过滤掉的属性名称
   * @returns
   */
  const filterProps = (props, filterPropArr) => {
    if (typeof props !== 'object' || !Array.isArray(filterPropArr)) {
      throw new Error('参数格式不正确')
    }

    let obj = {}
    Object.keys(props)
      .filter(key => !filterPropArr.includes(key))
      .map(key => {
        obj[key] = props[key]
      })
    return obj
  }

  const getProgressStyle = classnames(styles['defualt-progress'], {
    [className]: className
  })

  const getProItm = classnames(styles['progress-box-com'], {
    [`${styles['progress-box-com-02']}`]: currentValue === maxLevel
  })

  return (
    // 全局配置注入
    <ProgressContext.Provider
      value={mergeConfigToDefault(
        filterProps(props, ['levelList', 'currentValue'])
      )}
    >
      {/* 进度条-all */}
      <View
        className={styles['progress-box']}
        style={{ width: width / 100 + 'rem' }}
      >
        {/* 进度条-current */}
        <View
          className={getProItm}
          style={{
            width:
              currentValue >= maxLevel
                ? '100%'
                : (currentValue / maxLevel) * 100 + '%'
          }}
        />
        {/* 进度条节点 */}
        <View className={getProgressStyle}>
          {LevelList.map((item, index) => {
            return (
              <ProgressNode
                key={index}
                {...item}
                isReach={item.levelValue <= currentValue}
              />
            )
          })}
        </View>
      </View>
    </ProgressContext.Provider>
  )
})
export default Progress
