import React, { useState, useEffect } from "react";
import { View, Image, Text } from "@tarojs/components";
import styles from "./RotateWheel.module.less";
import { useThrottle } from "@/hooks/useThrottle";
import API from "@/api";
import { prizeList } from "@/mock";
import Taro, { showToast, redirectTo, navigateTo } from "@tarojs/taro";

const oneTurn = 360;

const RotateWheel = props => {
  const {
    containerInfo={width:600,height:600},
    bg = "https://yun.duiba.com.cn/spark/assets/8b6e920ffd09fab8f9ac2de09f9154879f4d0607.png",
    ratio = 0.65,
    radius = 300,
    circles = 4,
    divideNum = 8,
    duration = 5000,
    timeFunction = "ease-out",
    nodeInfo = { width: 100, height: 100 },
    imgInfo = { width: 80, height: 80 },
    showWay = "negative",
    isShowPrizeName = true,
    prizeNameWidthRatio = 1.2,
    callback = () => {}
  } = props;
  /* 奖品列表 */
  const [prizelist, setPrizelist] = useState(prizeList);
  /* 平分角度 */
  const [angle, setAngle] = useState(oneTurn / divideNum);
  /* 展示奖品列表 */
  const [show, setShow] = useState(false);
  /* 转动一圈时的角度值 */
  const [rotateInOneTurn, setRotateInOneTurn] = useState(0);
  /* 动画参数 */
  const [ani, setAni] = useState({
    startFlag: false,
    option: { duration: duration, timeFunction: timeFunction, rotate: 0 }
  });

  useEffect(() => {
    computePosition();
  }, [prizeList]);

  /**
   * @description 获取奖品列表
   */
  // const getPrizeListInfo = async () => {
  //     const {success,data,code,message} = await API.getRotatePrizeListInfo().catch((res)=>{
  //         showToast({title:res?.message ? res?.message : '网络异常，请稍后再试'})
  //     })
  //     if(success && data){
  //         const {list} = data;
  //         // setPrizelist(list)
  //         computePosition(list)
  //     }
  // }

  /**
   * @description 计算奖品位置，旋转角度
   */
  const computePosition = () => {
    if (!prizeList.length) return;
    let centerX, centerY, color, rotate;
    /* 获取每块奖品的中心位置 */
    prizelist.forEach((ele, i) => {
      if (i % 2 == 0) {
        color = "#527aff";
      } else {
        color = "#f13082";
      }

      // 当前奖品左上角位置
      if (showWay === "negative") {
        centerX =
          radius -
          ratio * radius * Math.sin(((angle / 2 + angle * i) / 180) * Math.PI);
        centerY =
          radius -
          ratio * radius * Math.cos(((angle / 2 + angle * i) / 180) * Math.PI);
        rotate = -(angle / 2 + angle * i);
      } else {
        centerX =
          radius -
          ratio * radius * Math.sin(((angle / 2 + angle * -i) / 180) * Math.PI);
        centerY =
          radius -
          ratio * radius * Math.cos(((angle / 2 + angle * -i) / 180) * Math.PI);
        // 旋转角度
        rotate = -(angle / 2 + angle * -i);
      }
      ele.rotate = rotate;
      ele.color = color;
      // 奖品位置
      let disleft = centerX - nodeInfo.width / 2;
      let distop = centerY - nodeInfo.height / 2;
      ele.centerX = disleft;
      ele.centerY = distop;
      ele.num = i;
      // 测试：设置奖品Id
      ele.prizeId = 100 + i;
    });
    console.log("prizelist", prizelist);
    setPrizelist(prizelist);
    setShow(true);
  };

  /**
   * @description 抽奖
   */
  const drawPrize = useThrottle(async () => {
    // const {success,data,message,code} = await API.drawRotatePrize().catch((res)=>{
    //     showToast({title:res?.message ? res?.message : '网络异常，请稍后再试'})
    // });
    // if(success && data){
    //     const {prizeId,id} = data;
    // }

    // test
    let prizeId = Math.floor(Math.random() * prizelist.length) + 100;
    startRotation(prizeId);
    setTimeout(() => {
      // 弹出弹窗
      callback && callback(); //prizeInfo
    }, duration + 1000);
  }, duration);

  /**
   * @description 根据奖品id开始旋转
   * @param {*} prizeId 抽中的奖品id
   */
  const startRotation = prizeId => {
    console.log("start");
    let rotateAngle;
    let num;
    let oneturnAngle;
    prizelist.forEach(ele => {
      if (ele.prizeId === prizeId) {
        num = ele.num;
      }
    });

    // 旋转角度 ( 旋转圈数 + 对应位置(0,7) ) * 平分角度 + 平分角度 / 2
    if (showWay === "negative") {
      rotateAngle = oneTurn * circles + num * angle + angle / 2;
      oneturnAngle = num * angle + angle / 2;
    } else {
      rotateAngle =
        oneTurn * circles + (prizelist.length - num) * angle + angle / 2;
      oneturnAngle = (prizelist.length - num) * angle + angle / 2;
    }
    console.log("rotateAngle", rotateAngle, num, prizeId);
    /* 执行动画 */
    setAni({
      startFlag: true,
      option: {
        ...ani.option,
        rotate: ani.option.rotate - rotateInOneTurn + rotateAngle
      }
    });
    setRotateInOneTurn(oneturnAngle);
  };

  return (
    <View
      className={styles["rotate"]}
      style={{
        width: `${containerInfo.width / 100}rem`,
        height: `${containerInfo.height / 100}rem`,
        display: "flex",
        justifyContent: "center",
        alignItems: "center"
      }}
    >
      <View
        className={`${styles["rotate_container"]}`}
        style={{
          backgroundImage: `url(${bg})`,
          transform: ani.startFlag ? `rotate(${ani.option.rotate}deg)` : "",
          transition: ani.startFlag
            ? `all ${ani.option.timeFunction} ${ani.option.duration}ms`
            : ""
        }}
      >
        {show &&
          prizelist.length &&
          prizelist.map((ele, i) => {
            return (
              <View
                className={styles["item"]}
                style={{
                  // backgroundColor:`${ele?.color}`,
                  width: `${nodeInfo.width / 100}rem`,
                  height: `${nodeInfo.height / 100}rem`,
                  transform: `rotate(${ele?.rotate}deg)`,
                  top: `${ele.centerY / 100}rem`,
                  left: `${ele.centerX / 100}rem`,
                  position: "absolute"
                }}
                key={"item" + i}
              >
                {isShowPrizeName && (
                  <View
                    className={styles["prize_name"]}
                    style={{
                      width: `${prizeNameWidthRatio * 100}%`,
                      height: `${30 / 100}rem`
                    }}
                  >
                    {ele.name}
                  </View>
                )}
                <View
                  className={styles["prize_img"]}
                  style={{
                    backgroundImage: `url(${ele.image})`,
                    width: `${imgInfo.width / 100}rem`,
                    height: `${imgInfo.height / 100}rem`
                  }}
                ></View>
              </View>
            );
          })}
      </View>
      <View className={styles["circle"]} onTap={drawPrize}>
        draw
      </View>
    </View>
  );
};
export default RotateWheel;
