import tbccTs from 'tbcc-sdk-ts'
import API from '@/api'
const { getUserAddress, commonToast } = tbccTs.tb

export const noopFn = () => { }
// 领取实物
const getUerAddressParam = async () => {
    const userAddress = await getUserAddress().catch(err => {
        commonToast(err.errorMessage);
    });
    if(!userAddress) return false
    const { name, telNumber, provinceName, cityName, cityCode, countyName, detailInfo, streetName } = userAddress || {};
    const params = {
        name,
        phone: telNumber,
        addressDetail: detailInfo,
        cityCode,
        city: cityName,
        province: provinceName,
        area: countyName,
        streetName,
    }
    return {
        params,
        duibaAddress: userAddress.duibaAddress.address
    }
}
const confirmAddress = async (address) => {
    return new Promise(async (resolve,reject) => {
        my.confirm({
            title: '提示',
            content: '确认使用该收货地址：' + address,
            success: (res) => {
                if(res.confirm) {
                    resolve(true)
                }else {
                    resolve(false)
                }
            },
        });
    })
}
export const receiveObjectPrize = async (data) => {
    const { params, successMsg, errorMsg } = data
    return new Promise(async (resolve,reject) => {
        const userInfo = await getUerAddressParam()
        if(!userInfo) {
            resolve(false)
            return;
        }
        const { params: _params, duibaAddress } = userInfo
        const { name, phone } = _params
        const address = name + phone + duibaAddress
        const canPass = await confirmAddress(address)
        if(!canPass) {
            resolve(false)
            return;
        }
        const { success, data, message } = await API.receiveObjectPrize({ ...params, ..._params })
        if (success) {
            commonToast(successMsg)
            resolve(true)
        }else {
            commonToast(errorMsg || message)
            resolve(false)
        }
    })
}
// 领取权益
export const receiveEnamePrize = async (data) => {
    const { params, successMsg, errorMsg } = data
    return new Promise(async (resolve,reject) => {
        const { success, data, message } = await API.receiveEnamePrize(params).catch(res => {
            commonToast(successMsg || res.message)
            resolve(false)
        });
        if (success) {
            commonToast(successMsg)
            resolve(true)
        }else {
            commonToast(errorMsg || message)
            resolve(false)
        }
    })
}
// 领取会员优惠券
const applyActivity = (sellerId, activityId) => {
    const memberBenefitPlugin = requirePlugin("memberBenefit")
    if(!memberBenefitPlugin) return false
    return new Promise(async (resolve,reject) => {
        memberBenefitPlugin.applyActivity({
            data: {     
              sellerId,
              activityId,
            },
            success: (result) => {
                resolve(result)
            },
            fail: (error) => {
                console.warn('领取商家权益失败'+JSON.stringify(error.data))
                resolve(error.data)
            }
          });
    })
}
export const receiveMemberEname = async(data) => {
    const { params, successMsg, errorMsg } = data
    const { sellerId, ename, ...ext } = params
    if(!ename) return false
    return new Promise(async (resolve,reject) => {
        const result = await applyActivity(sellerId,ename)
        if(!result) resolve(false)
        if(result.businessSuccess) {
            const { success, data, message } = await API.updateEnamePrizeReceived({ ...ext })
            if(success) {
                commonToast(successMsg || '奖品发放成功，请前往我的奖品处进行使用')
                resolve(true)
            }else {
                commonToast(errorMsg || message)
                resolve(false)
            }
        }else{
            commonToast(result.errorMsg)
            resolve(false)
        }
    })
}
//打点
export const addStat = async(activityId, type)=> {
    return new Promise(async (resolve,reject) => {
        const result = await API.addStat({ activityId, type }).catch(res => {
            commonToast(res && res.message);
        });
        if (result && result.success) {
            resolve(true)
        }
        resolve(false)
    })
}
export const createCanvas = async (canvasId) => {
    return new Promise((resolve,reject) => {
        my.createCanvas({
            id: canvasId,
            success: (ccc) => {
                resolve(ccc)
            }
        })
    })
}
// 查询商家权益活动
export const getActivity = (sellerId) => {
    const memberBenefitPlugin = requirePlugin("memberBenefit")
    if(!memberBenefitPlugin) return []
    return new Promise(async (resolve,reject) => {
        memberBenefitPlugin.getActivity({
            data: {     
              sellerId,
            },
            success: (result) => {
                resolve(result)
            },
            fail: (error) => {
                console.log('获取失败'+JSON.stringify(error))
                resolve(error)
            }
          });
    })
}

/**
 * 获取系统信息
 * @returns {object} 小程序系统信息
 */
 export const getSystemInfo = () => {
    return new Promise((resolve, reject) => {
      my.getSystemInfo({
        success: res => { resolve(res); },
        fail: err => { reject(err); }
      });
    });
};

// 查询商家会员等级
export const getGrade = (sellerId) => {
    const memberBenefitPlugin = requirePlugin("memberBenefit")
    if(!memberBenefitPlugin) return []
    return new Promise(async (resolve,reject) => {
        memberBenefitPlugin.getGrade({
            data: {     
              sellerId
            },
            success: (result) => {
                resolve(result)
            },
            fail: (error) => {
                console.log('查询商家会员等级失败'+JSON.stringify(error))
                resolve(error)
            }
          });
    })
}
// 查询商家会员等级
export const checkShopFavoredStatus = (sellerId) => {
    return new Promise(async (resolve,reject) => {
        my.tb.checkShopFavoredStatus({
            id: sellerId,
            success: (res) => {
                console.warn(res)
                my.alert({ content: JSON.stringify(res) })
                resolve(res.isFavor)
            },
            fail: (res) => {
                my.alert({ content: JSON.stringify(res) })
            }
        })
    })
}
// 查询商家会员等级
export const favorShop = (sellerId) => {
    return new Promise(async (resolve,reject) => {
        my.tb.favorShop({
            id: +sellerId,
            success: (res) => {
                console.warn(res)
                my.alert({ content: JSON.stringify(res) })
                resolve(res)
            },
            fail: (res) => {
                my.alert({ content: JSON.stringify(res) })
            }
        })
    })
}


