import React, { useState, useEffect, useRef } from 'react'
import { View } from '@tarojs/components'
import ContainerFit from '@/components/_base/ContainerFit/ContainerFit'
import TitleImg from '@/components/_tb_comps/TitleImg/TitleImg'
import GoodsList from '@/components/_tb_comps/GoodsList/GoodsList'
import { useRouter } from '@tarojs/taro'
import tbccTs from 'tbcc-sdk-ts'
import API from '@/api'
import { useThrottle } from '@/hooks/useThrottle'
const { commonToast } = tbccTs.tb
import styles from './collectGoods.module.less'
import COLLECT_CONFIG from '@/config/collect.config'

function CollectGoodsPage() {
  const router = useRouter()
  const [goodsList, setGoodsList] = useState([])
  const { itemIds } = router?.params
  // 收藏状态
  const collectFlag = useRef(false)

  useEffect(() => {
    getGoodsList()
  }, [])

  const getGoodsList = async () => {
    const { data } = await API.getCollectGoodsList({ itemIds })
    setGoodsList(data?.list || [])
  }

  const onCompleteTask = useThrottle(async(itemId,collected) => {
    const collectFn = async () => {
      const { success } = await API.completeTask({ key: taskType, itemId })
      if (success) {
        collectFlag.current = true
        getGoodsList()
        commonToast('收藏成功')
      }
    }
    // 今日是否已收藏过
    if(collectFlag.current) {
        commonToast('任务已完成，请明日再来')
        return;
    }
    if (collected) {
        commonToast('您已收藏过该商品了')
        return;
    }
    // 判断是否活动外已收藏商品
    const isCollected = await checkGoodsCollectedStatus(+itemId)
    if (isCollected) {
        collectFn()
        return;
    }
    const result = await collectGoods(+itemId)
    if (result) {
      collectFn()
      return;
    }
  })

  return (
    <ContainerFit bg={COLLECT_CONFIG.bg}>
      <View className={styles['page-content__title']}>
        <TitleImg config={COLLECT_CONFIG.head}/>
      </View>
      <View className={styles['page-content__list']}>
        <GoodsList goodsList={goodsList} task={COLLECT_CONFIG} onOpenDetail={(itemId,collected) => onCompleteTask(itemId,collected)} />
      </View>
    </ContainerFit>
  )
}

export default CollectGoodsPage
