import API from '@/api'
import { useThrottle } from '@/hooks/useThrottle'
import { useState, useEffect, useRef } from 'react'
import { useDidShow } from '@tarojs/taro'
import { useLoginInfoModel } from '@/store'
import { checkIsMember } from 'tbcc-sdk-ts/lib/utils'
import { commonToast, navigateTo, favorShop, checkShopFavoredStatus, navigateToOutside, showSharePanel, navigateToTaobaoPage } from 'tbcc-sdk-ts/lib/core/tb'
import { TASK_DATA } from '@/mock'
import { SHOP_ID } from '@/const'
import config from '@/config/config'
import { TASK_CONFIG, ORDER_GOOD_TYPE, BROSE_GOOD_TYPE, TASK_STATUS, TASK_SHOW_TYPE } from '@/config/task.config'

const { jumpType, browseTime, showTaskType, browseType, orderType, successMsg, isMock = false } = TASK_CONFIG
export function useTasks(props) {
  const { onUpdate } = props
  const app = getApp()
  const { loginInfo } = useLoginInfoModel()
  const [ taskList, setTaskList ] = useState(isMock ? TASK_DATA : [])

  const [ currentTaskType, setCurrentTaskType ] = useState('')
  const preBrowseTime = useRef(null)
  // 页面显示
  useDidShow(() => {
    if (app.isFlashTask) {
      app.isFlashTask = false
      if (preBrowseTime.current && ((Date.now() - preBrowseTime.current) / 1000) >= browseTime && currentTaskType !== 'browseGoods') {
        doCompleteTaskHandle(currentTaskType, true)
        preBrowseTime.current = null
      } else if(preBrowseTime.current && ((Date.now() - preBrowseTime.current) / 1000) < browseTime) {
        commonToast(`未达到${browseTime}秒~`)
        preBrowseTime.current = null
      }else {
        fetchTaskList()
      }
    }
  })
  // 数据初始化
  useEffect(() => {
    if(showTaskType === TASK_SHOW_TYPE.LIST && loginInfo.isLogin) {
      fetchTaskList()
    }else if(showTaskType === TASK_SHOW_TYPE.MODAL){
      fetchTaskList()
    }
  },[loginInfo])
  // 任务数据获取
  const fetchTaskList = async () => {
    const isVip = await checkIsMember()
    const { success, data } = await API.getTaskList({ isVip })
    if(success && data) {
      const { list = [] } = data
      setTaskList(list)
    }
  }
  // 点击任务项
  const handleItem = useThrottle(async(item) => {
    const { status, taskType } = item
    const tapFn = {
      [TASK_STATUS.WAIT_RECEIVE]: async() => {
        const { success, data } = await API.receiveTask({ key: taskType, rewardsKey: 'totalHotValue' })
        if (success && data) {
          const { rewards } = data
          commonToast(`${successMsg}${rewards}`)
          fetchTaskList()
          onUpdate && onUpdate()
        }
      },
      [TASK_STATUS.WAIT_DO]: () => completeTask(item)
    }
    tapFn[status] && tapFn[status]()
  })
  // 完成任务处理
  const completeTask = async(item) => {
    const { taskType, url, itemIds, keepTime } = item
    setCurrentTaskType(taskType)
    const completeFn = {
      member: () => setMemberShopVisible(true),
      invites: () => showSharePanel(),
      follow: async () => {
        // 已关注店铺直接完成任务
        const isFollow = await checkShopFavoredStatus(config.sellerId)
        if (isFollow) {
          doCompleteTaskHandle(taskType)
          return;
        }
        // 未关注店铺直接关注并完成任务
        const checkFollow = await favorShop(config.sellerId)
        if(checkFollow) {
          doCompleteTaskHandle(taskType)
          return;
        }
      },
      // 跳转任务 https://www.feizhu.com
      jumpLink: async() => {
        navigateToOutside(url)
        if (jumpType === 2) {
          doCompleteTaskHandle(taskType)
        } else {
          app.isFlashTask = true
          preBrowseTime.current = Date.now()
        }
        // await API.addStat({ type: 'BROWSE_LIVE'})
      },
      browseGoods: async() => {
        app.isFlashTask = true
        if(browseType === BROSE_GOOD_TYPE.PAGE) preBrowseTime.current = Date.now()
        navigateTo(`/pages/packageGood/browseGoods/browseGoods?itemIds=${itemIds}&keepTime=${keepTime}`)
      },
      orderGoods: async() => {
        app.isFlashTask = true
        if(orderType === ORDER_GOOD_TYPE.PAGE) {
          navigateTo(`/pages/packageGood/orderGoods/orderGoods?itemIds=${itemIds}`)
        }else {
          await navigateToTaobaoPage(SHOP_ID)
        }
      },
      collectGoods: async() => {
        app.isFlashTask = true
        navigateTo(`/pages/packageGood/collectGoods/collectGoods?itemIds=${itemIds}`)
      },
      sign: () => doCompleteTaskHandle(taskType),
      share: () => {
        showSharePanel();
        setTimeout(() => {
          doCompleteTaskHandle(taskType)
        }, 2000);
      }
    }
    completeFn[taskType] && completeFn[taskType]()
  }
  // 完成任务接口调用
  const doCompleteTaskHandle = async(taskType) => {
    const { success } = await API.completeTask({ key: taskType })
    if (success) {
      await fetchTaskList()
    }
  }
  return {
    taskList,
    handleItem,
    fetchTaskList
  }
}
