import { View, Text, Image } from '@tarojs/components'
import React, { useState } from 'react'
import { useThrottle } from '@/hooks/useThrottle'
import Modal from '@/components/_base/Modal/Modal'
import styles from './DoHelpModal.module.less'
import API from '@/api'
import { useLoginInfoModel, useActivityInfoModel } from '@/store'
import { checkIsMember } from 'tbcc-sdk-ts/lib/utils'
import { commonToast } from 'tbcc-sdk-ts/lib/core/tb'
import { HELP_MODAL_TYPE, HELP_CONFIG } from '@/config/help.config'

export default function DoHelpModal(props) {
  const { activityInfo } = useActivityInfoModel()
  const { type = HELP_MODAL_TYPE.HELP, onClose = () => {}, newVip = true, helpInfo = {} } = props
  const [ memberModalVisible, setMemberModalVisible ] = useState(false)

  const { loginInfo: { inviteId } } = useLoginInfoModel()

  const onAuthSuccess = async () => {
    const isVip = await checkIsMember()
    const helpRes = await API.doHelp({ inviteId, isVip })
    if (helpRes?.success) {
      commonToast('助力成功')
    } else {
      commonToast(helpRes?.message)
    }
    onClose()
    setMemberModalVisible(false)
  }
  const onAuthFail = () => {
    setMemberModalVisible(false)
  }
  const closeMemberModal = () => {
    setMemberModalVisible(false)
  }
  const onHandleHelp = useThrottle(async () => {
    const helpFn = {
      [HELP_MODAL_TYPE.HELP]: async () => {
        // 条件不是需要新会员的情况下，直接助力
        if (!newVip) {
          const helpRes = await API.doHelp({ inviteId, isVip })

          if (helpRes?.success) {
            commonToast('助力成功')
          } else {
            commonToast(helpRes?.message)
          }
          onClose()
        }
        // 助力条件为新会员
        const isVip = await checkIsMember()
        // 已经是会员
        if (isVip) {
          commonToast('新会员才能助力哦~')
        } else {
          // 还不是会员，弹出会员弹窗
          setMemberModalVisible(true)
        }
      },
      [HELP_MODAL_TYPE.FAIL]: async () => onClose(type),
      [HELP_MODAL_TYPE.REWARDS]: async () => {
        const { success, data } = await API.receiveTask({ taskType: 'invites' })
        if(success && data) {
          onClose(type)
        }
      }
    }
    helpFn[type]()
  })
  const onCloseModal = () => {
    if(type === HELP_MODAL_TYPE.REWARDS) {
      onHandleHelp()
      return;
    }
    onClose && onClose()
  }
  return (
    <View>
      <Modal hideCloseButton={false} onClose={onCloseModal} top={'50%'} closePos={{ right: 0, top: 0 }}>
        <View className={styles.container} style={
              { width: HELP_CONFIG[type].width / 100 + 'rem', 
                height: HELP_CONFIG[type].height / 100 + 'rem',
                backgroundImage: `url(${HELP_CONFIG[type].bg})`
        }}>
            <Text className={styles['help-title']}>{
              type !== HELP_MODAL_TYPE.REWARDS ? HELP_CONFIG[type].title : 
                `恭喜你成功邀请${helpInfo.inviteCount}名好友\n获得XXX奖励` }
            </Text>
            <Image src={HELP_CONFIG[type].btnTxt} 
              style={{ marginBottom: HELP_CONFIG[type].marginBottom / 100 + 'rem' }} 
              className={styles['help-btn']} onClick={() => onHandleHelp()} />
        </View>
      </Modal>
      {
        memberModalVisible &&
          <member-modal
            onClose={() => closeMemberModal()}
            onAuthFail={onAuthFail}
            onAuthSuccess={onAuthSuccess}
          />
      }
    </View>
  )
}