/**
   * 任务类型（taskType）:collectGoods、 orderGoods 、browseGoods、exchangeCredits
   * task: {
   *  itemId: //商品ID
   *  taskType: //任务类型
   *  type: //头部样式（02——banner，01——标题）
   *  image: {//图片
   *    bg: //集合页背景
   *    banner: //头部banner
   *    title: //头部title
   *    collect: //商品以收藏
   *    no_collect: //商品未收藏
   *  }
   *  color: //商品名称：文字颜色
   * }
 */
const app = getApp();
const { tbcc } = app;
const { openDetail, collectGoods, checkGoodsCollectedStatus, commonToast } = tbcc.tb;
import API from '../../api';

Page({
  data: {
    query: {},
    task: {},
    isBackFlag: 1,
    goodsList: []
  },
  onLoad(query) {
    this.query = query || {}
    this.init()
  },
  onShow() {
    //重新回到页面开启倒计时
    this.setData({ isBackFlag: Math.floor((Math.random() * 100)) == this.data.isBackFlag ? 101 : Math.floor((Math.random() * 100)) })
  },
  init() {
    const { itemId, taskType } = this.query
    this.setData({
      task: {
        itemId,
        taskType,
        type: '01',
        image: {
          bg: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_bg@2x.png',
          banner: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_banner@2x.png',
          title: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_title@2x.png',
          collect: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_collection@2x.png',
          no_collect: '//yun.duiba.com.cn/taobaomini/clientCTest/collection_no_collect@2x.png',
          img: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_img@2x.png',
        },
        color: '#181818'
      }
    })
    this.initPage()
  },
  async initPage() {
    const { activityId } = app
    const { taskType, itemIds } = this.query

    let handel = taskType == 'collectGoods' ? 'getCollectItemList' : 'getItemListByItemIds'
    const { success, data } = await API[handel]({ activityId, itemIds }).catch(res => {
      res && commonToast(res)
    }) || {}
    if(success) {
       this.setData({ goodsList: data || [] })
    }
  },
  //任务完成
  async onCompleteTask(taskType,itemId) {
    console.log(taskType,itemId)
    const { activityId } = app
    switch(taskType) {
      case 'collectGoods':
        let { success, data } = await API.doCollectGoodsTask({ activityId, itemId }).catch(res => {
          res && commonToast(res)
        }) || {}
        if(success) {
          this.initPage()
        }
        break;
      case 'browseGoods':
        let browsResult = await API.doBrowseGoodsTask({ activityId, itemId }).catch(res => {
          res && commonToast(res)
        }) || {}
        console.log(browsResult)
        if(browsResult.success) {
          commonToast('任务完成，请到任务中心查看奖励')
        }
        break;
    }
  }
});
