import moment from 'moment';
import { getActivityDetail, saveActivityInfo } from '../../../api';
import { activityType } from '../const';
import { addFloat } from '../../../utils/helper';


Component({
  data: {
    activityInfos: {},
    timeRange: [],
    startTime: '',
    endTime: '',
    labelCol: {
      fixedSpan: 5
    }
  },
  props: {},
  didMount() {
    const { id } = this.$page.$router.params;
    if (id || id === 0) {
      this.getActivityInfo(id);
    } else {
      this.setDefaultTime();
    }
  },
  methods: {
    // 创建活动时, 根据规则设置活动时间
    setDefaultTime() {
      let nowTime = new Date().getTime();
      let oneDay = 24 * 3600 * 1000;

      // 当前时间 + 10分钟
      let startNow = moment(nowTime + 600000).format("YYYY-MM-DD HH:mm:ss");
      // 开始时间 + 7天
      let endNow = moment(nowTime + 600000 + 7 * oneDay).format("YYYY-MM-DD HH:mm:ss");

      this.setData({
        timeRange: [ startNow, endNow ],
        startTime: startNow,
        endTime: endNow
      })
    },
    backToActivityList() {
      this.$page.$router.push('/activity/list')
    },
    // 获取id活动信息
    async getActivityInfo(activityId) {
      try {
        const { success, data, message } = await getActivityDetail({ activityId, activityType });
        if (!success) {
          this.showFailToast(message);
          return;
        }

        let { prizeInfoList, ...rest } = data;
        const startTime = moment(+rest.startTime).format("YYYY-MM-DD HH:mm:ss");
        const endTime = moment(+rest.endTime).format("YYYY-MM-DD HH:mm:ss");

        this.setData({
          activityInfos: data
        })

      } catch (error) {
        console.log(err, 'err')
      }
    }
  }
});