/** @format */

import { cfg as online } from './online'
import { cfg as test } from './test'

export interface IConfig {
  vipCallBackUrl: string
}

const configs = {
  online,
  test,
  mock: test
}

// 根据服务环境获取配置
export const getConfig = (context: IContext<{}>): IConfig => {
  const env = context.env
  return configs[env] || configs.online
}
