/** @format */
import { services, checkParams, preUpdate } from '../../decorator/common'
import { updateVip, updateSignTask, updateOrderGoods } from '../../utils/common/update'
import customUtil from '../../utils/custom'
import { resultsModel } from '../../sdk'
import { CommonStatService } from '../../service/common'

export default class Test2Controller {
  /**
   *  增加埋点记录
   */
  @checkParams(['activityId', 'type'])
  @services([CommonStatService])
  async test2addStat(
    context: IContext<IParams>,
    { activityInfo, userInfo }: IControllerInfos,
    [commonStatService]: [CommonStatService]
  ) {
    const commonStatAddStatResult1 = await commonStatService.addStat(context.data.type, userInfo)
    return resultsModel.success({
      ...commonStatAddStatResult1
    })
  }
  /**
   *  统计数据
   */
  @checkParams(['activityId', 'startDay', 'endDay'])
  @services([CommonStatService])
  @preUpdate([updateVip, updateSignTask, updateOrderGoods])
  async test2getStats(
    context: IContext<IParams>,
    { activityInfo, userInfo }: IControllerInfos,
    [commonStatService]: [CommonStatService]
  ) {
    const commonStatGetStatsResult1 = await commonStatService.getStats(
      context.data.activityId,
      context.data.startDay,
      context.data.endDay
    )
    const commonStatBuildExcelResult2 = await commonStatService.buildExcel(
      context.data.startDay,
      context.data.endDay,
      commonStatGetStatsResult1
    )
    return resultsModel.success({
      ...commonStatBuildExcelResult2
    })
  }
}
