/** @format */
import { BaseDao } from '../../sdk'
import { ERROR_LOG_DB_NAME } from '../../db'
import { getToday } from '../../utils'

export const logFn = (context: IContext<IParams>) => {
  const data = JSON.stringify(context.data)
  console.log(
    `---------函数: ${context.fcName || ''}.${
      context?.cloud?.dataspace?.context?.handler || context.handler
    }------------`
  )
  console.log(`---------请求参数: ${data}------------`)
}

// 记录错误日志
export const recordErrorLog = async (
  context: IContext<IParams>,
  baseInfos: IControllerInfos,
  errorMsg: string,
  stack: string
) => {
  const { openId } = context
  const { activityId } = context.data || {}
  const { userInfo } = baseInfos
  const { userNick } = userInfo || {}
  const logdao: IBaseDao = new BaseDao(context, ERROR_LOG_DB_NAME)
  const functionName: string = `${context.fcName || ''}.${
    context?.cloud?.dataspace?.context?.handler || context.handler
  }`
  return await logdao.insertOne({
    openId,
    activityId,
    errorMsg,
    errorStack: stack,
    functionName,
    userNick,
    fcInvokeId: context.fcInvokeId,
    params: context.data,
    createTime: Date.now(),
    createDay: getToday(),
    catchType: 1
  })
}

// 本地mock 增加颜色辨识度
export const logger = (message: any) => {
  console.log('\x1b[36m%s\x1b[0m', `-------------------日志----------------------------`)
  console.log('\x1b[36m%s\x1b[0m', JSON.stringify(message, null, 2))
  console.log('\x1b[36m%s\x1b[0m', `-------------------日志----------------------------`)

  // console.log(`\033[42;30m 日志 \033[40;32m ${message} \033[0m`)
}
