/** @format */

interface IErrorResult {
  success: false
  code: string
  message?: string
  data?: object[] | object | number[] | string[] | boolean | string
}
interface ISuccessResult<T> {
  success: true
  data?: T
}

interface ICodeType {
  code: string
  defaultMsg: string
}

type IResult<T> = T extends ICodeType ? IErrorResult : IErrorResult | ISuccessResult<T>
