/** @format */

import { DEFAULT_CODE_TYPES } from './sdk'

export const BusinessError = {
  // 更新重试失败(用于并发更新)
  ERROR_UPDATE_RETRY: {
    code: `210001`,
    defaultMsg: `系统错误`
  },
  // 活动不存在
  ERROR_NO_ACTIVITY: {
    code: `220001`,
    defaultMsg: `活动不存在`
  },
  // 活动未开始
  ERROR_ACTIVITY_NOSTART: {
    code: `220002`,
    defaultMsg: `活动未开始`
  },
  // 活动已结束
  ERROR_ACTIVITY_OVER: {
    code: `220003`,
    defaultMsg: `活动已结束`
  },
  // 活动未结束
  ERROR_ACTIVITY_NO_OVER: {
    code: `220004`,
    defaultMsg: `活动未结束`
  },
  // 活动已开奖
  ERROR_ACTIVITY_OPENED_PRIZE: {
    code: `220005`,
    defaultMsg: `活动已开奖`
  },
  // 用户不存在
  ERROR_NO_USER: {
    code: `310002`,
    defaultMsg: `用户不存在`
  },
  // 非店铺会员
  ERROR_NO_VIP: {
    code: `310003`,
    defaultMsg: '非店铺会员'
  },
  // 未关注店铺
  ERROR_NO_FOLLOW: {
    code: `310004`,
    defaultMsg: '未关注店铺'
  },
  // 暂无次数可领取
  ERROR_TASK_NORECEIVE: {
    code: `430001`,
    defaultMsg: `该任务暂无领取次数`
  },
  // 任务奖励已领取
  ERROR_TASK_ALREADYRECEIVE: {
    code: `430002`,
    defaultMsg: `任务奖励已领取`
  },
  // 任务已完成
  ERROR_TASK_COMPLETE: {
    code: `430003`,
    defaultMsg: `任务已完成`
  },
  ERROR_INVALID_INVITE_ID: {
    code: `430004`,
    defaultMsg: `邀请码无效`
  },
  ERROR_NO_CREDITS: {
    code: `430005`,
    defaultMsg: `任务所需积分不足`
  },
  ERROR_TASK_LIMIT: {
    code: `430006`,
    defaultMsg: `今日该任务次数超限`
  },
  ERROR_AREADY_INVITE_SUCCESS: {
    code: `430007`,
    defaultMsg: `已经成功邀请过`
  },
  ERROR_NO_INVITE_SELF: {
    code: `430008`,
    defaultMsg: `自己不能给自己助力`
  },
  ERROR_INVITE: {
    code: `430009`,
    defaultMsg: `只有新会员才能助力哦~`
  },
  ERROR_DO_TASK: {
    code: `430010`,
    defaultMsg: `任务完成失败~`
  },
  ERROR_FORBIDDEN_OPE: {
    code: `530001`,
    defaultMsg: `非法操作`
  },
  ERROR_RECEIVE_PRIZE: {
    code: `630002`,
    defaultMsg: `奖励已领取`
  },
  ERROR_SEND_PRIZE: {
    code: `730001`,
    defaultMsg: `发奖失败`
  },
  ERROR_NO_PRIZE: {
    code: `730002`,
    defaultMsg: `奖品不存在`
  },
  ERROR_NO_STOCK: {
    code: `730003`,
    defaultMsg: `库存不足`
  },
  ERROR_PRIZE_EXPIRED: {
    code: `740001`,
    defaultMsg: `奖品已超过领取时间`
  }
}

export const CODE_TYPES = Object.assign({}, DEFAULT_CODE_TYPES, BusinessError)
