/** @format */

import { services, checkParams, preCheck, preUpdate } from '../decorator/common'
import { resultsModel } from '../sdk'
import { CommonCardService } from '../service/common'
import {
  checkActivityTime,
  checkJoinId,
  checkUserInfo,
  checkVip,
  checkGameTimes,
  checkOpenPrizeStatus
} from '../utils/common/check'
import { updateUserInfo, reduceGameTimes } from '../utils/common/update'

export interface ISumitGameControllerInfos extends IControllerInfos {
  joinInfo: IJoinRecord
}

export default class Card {
  @checkParams(['activityId'])
  @services([CommonCardService])
  async getCollectCardInfo(
    context: IContext<IParams>,
    { userInfo, activityInfo }: IControllerInfos,
    [cardService]: [CommonCardService]
  ) {
    const { joinedTimes, gameTimes } = userInfo
  }

  @checkParams(['activityId'])
  @services([CommonCardService])
  @preCheck([checkActivityTime, checkVip])
  async doJoin(
    context: IContext<IParams>,
    { userInfo, activityInfo }: IControllerInfos,
    [cardService]: [CommonCardService]
  ) {
    const { joinedTimes, gameTimes } = userInfo
  }
}
