/** @format */

// 获取去重后的装饰器
function getDecorators(controller, decoratorType) {
  let decorators = decoratorType === 'common' ? [{ type: 'common', name: 'services' }] : []
  decorators = [...decorators, ...Object.values(controller).map(v => v.decorators)].flat()
  return [...new Set(decorators.filter(v => v.type === (decoratorType || 'common')).map(v => v.name))]
}

function getPreChecks(controller, checkType) {
  checkType = checkType || 'common'
  let decorators = []
  decorators = [...decorators, ...Object.values(controller).map(v => v.decorators)].flat()

  const preChecks = [...decorators.filter(v => v.type === 'common' && v.name === 'preCheck').map(v => v.params)].flat()
  return [...new Set(preChecks.filter(v => v.type === checkType && v.behave === 'check').map(v => v.name))]
}

function getPreUpdates(controller, updateType) {
  updateType = updateType || 'common'
  let decorators = []
  decorators = [...decorators, ...Object.values(controller).map(v => v.decorators)].flat()
  const preUpdates = [
    ...decorators.filter(v => v.type === 'common' && v.name === 'preUpdate').map(v => v.params)
  ].flat()
  return [...new Set(preUpdates.filter(v => v.type === updateType && v.behave === 'update').map(v => v.name))]
}

module.exports = {
  getDecorators,
  getPreChecks,
  getPreUpdates
}
