const path = require('path')

module.exports = {
  mode: 'development',
  devtool: 'source-map',
  entry: {
    index: './src/main.ts'
  },
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        exclude: /(node_modules)/,
        use: [
          {
          loader: 'ts-loader',
        }
      ],
        exclude: /node_modules/
      }
    ],
  },
  resolve: {
    alias: {
      '@': './src',
    },
    extensions: ['.ts', '.js', 'tsx']
  },
  output: {
    filename: 'bundle.js',
    path: path.resolve(__dirname, './dist')
  },
  devServer: {
    port: '0.0.0.0',
    hot: true,
    open: true,
    port: 9015
  }
}