const path = require('path')

module.exports = {
  mode: 'development',
  devtool: 'source-map',
  entry: {
    index: './src/index.ts'
  },
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        exclude: /(node_modules)/,
        use: [
          {
          loader: 'ts-loader',
        }
      ],
        exclude: /node_modules/
      }
    ],
  },
  resolve: {
    alias: {
      '@': './src'
    },
    extensions: ['.ts', '.js', 'tsx']
  },
  output: {
    filename: 'output.js',
    path: __dirname,
    libraryTarget: 'umd'
  }
}