// import { Vector3 } from 'three';
// import { Vector3 } from "three"



declare module 'oimo' {
  export interface BodyConfig {
    type: string,
    size: number[],
    pos: number[],
    move: boolean,
    config: any[],
    name: string,
    mass: number,
    massPos: number[],
    density: number // 密度
    friction: number // 摩擦力
  }

  export class RigidBody {
    getPosition(): Vector3
    getQuaternion(): Vector3
    applyImpulse(position: Vector3, force: Vector3)
  }

  export class World {
    constructor(config: {
      info?: boolean
      timestep: number,
      gravity?: number[]
    })
    step()
    add: (config: Partial<BodyConfig>) => RigidBody
    initBody(type: string, o: BodyConfig)
  }
}