import { EventDispatcher } from "../EventDispatcher"

type KeyDownCallBack = (e?: KeyboardEvent) => void


export class KeyBoardState extends EventDispatcher {
  constructor() {
    super()
    this.initEvents()
  }

  private keyState: any = {}

  private initEvents() {
    document.addEventListener('keydown', (e: KeyboardEvent) => {
      const key = e.key
      const code = e.code
      for (let k of [key+'-down', code+'-down']) {
        this.dispatchEvent(k, e)
      }
      
      this.keyState[key] = true
      this.keyState[code] = true
    })

    document.addEventListener('keyup', (e) => {
      const key = e.key
      const code = e.code

      for (let k of [key+'-up', code+'-up']) {
        this.dispatchEvent(k, e)
      }
      this.keyState[key] = false
      this.keyState[code] = false
    })
  }

  /**
   * 监听事件
   * @param key 
   * @param callback 
   */
  onKeyDown(key: string, callback: KeyDownCallBack, context?: any) {
    // @ts-expect-error
    this.addEventListener(key+'-down', callback, context)
  }

  /**
   * 删除事件 监听
   * @param key 
   * @param callback 
   */
  removeKeyDown(key: string, callback: KeyDownCallBack) {
    // @ts-expect-error
    this.removeEventListener(key+'-down', callback)
  }

  isPressed(key: string) {
    return this.keyState[key.toUpperCase()] || this.keyState[key.toLocaleLowerCase()]
  }
}

export const KeyBoardStateStore = new KeyBoardState()