import * as THREE from 'three'
import { RES } from '../../RES'

export class PreloadGroup extends THREE.Group {
  get groupNames(): string[] { return null }

  constructor(...args: any[]) {
    super()
    
    this._preloadRes()
  }

  _preloadRes() {
    new Promise((resolve, reject) => {
      if (this.groupNames && this.groupNames.length) {
        Promise.all(
          this.groupNames.map(name => RES.loadGroup(name))
        ).then(resolve, reject)
      } else {
        resolve(1)
      }
    }).then(this.initUi)
  }

  protected initUi() {}
}