type BaseEventMap = {
  [eventName: string]: any
}

type EventCall<T extends any, S extends any = any, U extends any = any> = (this: S, e?: {
  type: T,
  data: U
}) => any

// type BaseEvent = {
//   type: string
// }

// type AddRecordArgs2<T extends Record<string, any>, E extends >

/**
 * Event object.
 */
// export interface Event extends BaseEvent {
//   target?: any;
//   [attachment: string]: any;
// }

export class NewEventDispatcher<E extends BaseEventMap> {
  private listeners: {
    [key in keyof E]?: {
      listener: EventCall<key>,
      context: any
    }[]
  }

  constructor() {
    this.listeners = Object.create(null)
  }

  addEventListener<T extends keyof E, S extends any>(type: T, listener: EventCall<T, S, E[T]>, context?: S) {
    if (!this.listeners[type]) {
      this.listeners[type] = []
    }
    this.listeners[type]!.push({
      listener,
      context
    })
  }

  removeEventListener<T extends keyof E, S extends any>(type: T, listener: EventCall<T, S, E[T]>, context?: S) {
    if (!this.listeners[type]) {
      return
    }
    const cbs = this.listeners[type]!
    let i = cbs.length - 1
    while (i >= 0) {
      const cb = cbs[i]
      if (cb.listener === listener && cb.context === context) {
        cbs.splice(i, 1)
      }
      i --
    }
  }

  removeAllEventListener() {
    this.listeners = Object.create(null)
  }

  onceEventListener<T extends keyof E, S extends any>(type: T, listener: EventCall<T, S, E[T]>, context?: S) {
    const once = (e: any) => {
      listener.call(context, e)
      this.removeEventListener(type, once)
    }
    this.addEventListener(type, once, this)
  }

  dispatchEvent<T extends keyof E>(type: T, args: E[T]) {
    if (!this.listeners[type]) {
      return
    }
    const array = this.listeners[type].slice(0)
    array.forEach(item => {
      const {
        listener,
        context
      } = item
      listener.call(context, {
        type,
        data: args
      })
    })
  }
}

// type t1 = {
//   'test1': {
//     t: boolean
//   },
//   'test2': boolean
// }

// type EnumType = keyof t1

// const tt = new NewEventDispatcher<t1>()

// tt.onceEventListener('test1', function (e) {
//   this.a = 2
//   e.data = 1
// }, {
//   a: 2
// })

// tt.dispatchEvent('test1', {
//   t: false
// })