type EventCall<T extends any> = (e?: {
  type: T,
  data: any
}, ...arg1: any[]) => any

export class EventDispatcher<EventsKeyName extends string = string> {
  private listeners: {
    [key in EventsKeyName]?: {
      listener: EventCall<EventsKeyName>,
      context: any
    }[]
  } = {}
  constructor() {
    this.listeners = Object.create(null)
  }
  addEventListener(type: EventsKeyName, listener: EventCall<EventsKeyName>, context?: any) {
    if (!this.listeners[type]) {
      this.listeners[type] = []
    }
    this.listeners[type]!.push({
      listener,
      context
    })
  }
  removeEventListener(type: EventsKeyName, listener: EventCall<EventsKeyName>) {
    if (!this.listeners[type]) {
      return
    }
    const cbs = this.listeners[type]!
    let i = cbs.length - 1
    while (i >= 0) {
      const cb = cbs[i]
      if (cb.listener === listener) {
        cbs.splice(i, 1)
      }
      i --
    }
    // const index = this.listeners[type]!.findIndex(item => item.listener === listener)
    // if (index > -1) {
    //   this.listeners[type]!.splice(index, 1)
    // }
  }

  removeAllEventListener() {
    this.listeners = Object.create(null)
  }

  onceEventListener(type: EventsKeyName, listener: EventCall<EventsKeyName>, context?: any) {
    const once = (...args: any[]) => {
      listener.apply(context, args)
      this.removeEventListener(type, once)
    }
    this.addEventListener(type, once, this)
  }

  dispatchEvent(type: EventsKeyName, args?: any) {
    if (!this.listeners[type]) {
      return
    }
    const array = this.listeners[type].slice(0)
    array.forEach(item => {
      const {
        listener,
        context
      } = item
      listener.call(context, {
        type,
        data: args
      })
    })
  }
}