export namespace UIViewCtrls {
  let LoadingDom: HTMLElement
  let timeoutNum: any

  function createLoadingContainer() {
    const fragment = document.createDocumentFragment()
    const container = fragment.appendChild(document.createElement('div'))
    container.classList.add('load-container')
    container.appendChild(document.createElement('div')).classList.add('boxLoading')
    document.body.appendChild(fragment)
    return container
  }

  export function showLoading() {
    if (
      !LoadingDom
    ) {
      LoadingDom = createLoadingContainer()
    }
    LoadingDom.style.display = 'block'
  }

  export function hideLoading(delayTime: number = 0) {
    timeoutNum && clearTimeout(timeoutNum)
    if (LoadingDom) {
      setTimeout(() => {
        LoadingDom.style.display = 'none'
      }, delayTime)
    }
  }
}