import * as THREE from 'three'

interface BodyConfig {
  mass: number,
  friction: number // 摩擦力
  restitution: number // 弹性
}

interface DynamicBody {
  initPhysics: (w: Ammo.btDiscreteDynamicsWorld) => void
  update: (delta: number) => void
}

export class AmmoPhysicWorld {
  static AmmoPhysicsWorldIns: AmmoPhysicWorld
  static getPhysicsWorldIns = (() => {
    return () => {
      return this.AmmoPhysicsWorldIns || (this.AmmoPhysicsWorldIns = new AmmoPhysicWorld())
    }
  })()

  physicWorld: Ammo.btDiscreteDynamicsWorld
  meshes: THREE.Mesh[] = []
  meshesMap: WeakMap<THREE.Mesh, Ammo.btRigidBody> = new WeakMap()
  clock: THREE.Clock
  syncList: Function[] = []
  DISABLE_DEACTIVATION: number = 4
  TRANSFORM_AUX: Ammo.btTransform = new Ammo.btTransform();
  ZERO_QUATERNION: THREE.Quaternion = new THREE.Quaternion(0, 0, 0, 1);
  DEFAULTVECTOR3: THREE.Vector3 = new THREE.Vector3()
  DEFAULT_MATRIX3: THREE.Matrix3 = new THREE.Matrix3()

  dynamicBodyList: DynamicBody[] = []
  rigidBodyList: Ammo.btRigidBody[] = []
  
  constructor() {
    if (AmmoPhysicWorld.AmmoPhysicsWorldIns) return AmmoPhysicWorld.AmmoPhysicsWorldIns
    this.clock = new THREE.Clock();
    this.initPhysicWorld()
  }

  initPhysicWorld() {
    // btDefaultCollisionConfiguration 初始化一个默认碰撞配置
    const collisionConfiguration = new Ammo.btDefaultCollisionConfiguration();
    const dispatcher = new Ammo.btCollisionDispatcher( collisionConfiguration );
    // 宽相位
    const broadphase = new Ammo.btDbvtBroadphase();
    // 解算器
    const solver = new Ammo.btSequentialImpulseConstraintSolver();
    const physicsWorld = this.physicWorld = new Ammo.btDiscreteDynamicsWorld( dispatcher, broadphase, solver, collisionConfiguration );
    physicsWorld.setGravity( new Ammo.btVector3( 0, -12.82, 0 ) );
    
  }

  createMeshPhysicBody(mesh: THREE.Mesh, cfg: Partial<BodyConfig> = {}) {
    // console.log(mesh.type, mesh, mesh.geometry)
    // @ts-expect-error
    const parameters = mesh.geometry.parameters;
    const geometry = mesh.geometry;

    const finalCfg:BodyConfig = Object.assign({
      mass: 0,
      friction: 1,
      restitution: 0
    }, cfg)

    var transform = new Ammo.btTransform();
    transform.setIdentity();
    transform.setOrigin(new Ammo.btVector3(mesh.position.x, mesh.position.y, mesh.position.z));
    transform.setRotation(new Ammo.btQuaternion(mesh.quaternion.x, mesh.quaternion.y, mesh.quaternion.z, mesh.quaternion.w));
    // 运动状态
    var motionState = new Ammo.btDefaultMotionState(transform);
    // 局部惯性？
    var localInertia = new Ammo.btVector3(0, 0, 0);
    

		if (geometry.type === 'BoxGeometry') {
			const sx = parameters.width !== undefined ? parameters.width / 2 : 0.5;
			const sy = parameters.height !== undefined ? parameters.height / 2 : 0.5;
			const sz = parameters.depth !== undefined ? parameters.depth / 2 : 0.5;

      const btGeometryShape = new Ammo.btBoxShape(new Ammo.btVector3(sx, sy, sz));

      btGeometryShape.calculateLocalInertia(
        finalCfg.mass
        , localInertia);

      // 设置 ridigbody 属性，并new 一个 刚体
      const rbInfo = new Ammo.btRigidBodyConstructionInfo(finalCfg.mass, motionState, btGeometryShape, localInertia);
      const body = new Ammo.btRigidBody(rbInfo);
      body.setFriction(finalCfg.friction)
      body.setRestitution(finalCfg.restitution)
      this.physicWorld.addRigidBody(body)

      if (finalCfg.mass) {
        body.setActivationState(this.DISABLE_DEACTIVATION)
      }

			return body

		}
    //  else if ( geometry.type === 'SphereGeometry' || geometry.type === 'IcosahedronGeometry' ) {

		// 	const radius = parameters.radius !== undefined ? parameters.radius : 1;

		// 	return new OIMO.OSphereGeometry( radius );

		// }



		return null;
  }

  addMesh(mesh: THREE.Mesh, config: Partial<BodyConfig> = {}) {
    const ridigBody = this.createMeshPhysicBody(mesh, config)
    if (ridigBody) {
      this.meshes.push(mesh)
      this.meshesMap.set(mesh, ridigBody)
    }
    return ridigBody
  }

  addRigidBodyWithMeshObj(body: Ammo.btRigidBody) {
    this.physicWorld.addRigidBody(body)
    // TODO 这里先 mass 0 都去 更新视图 世界好了
    if (true || body._mass != 0) {
      this.rigidBodyList.push(body)
    }
    
  }

  addDynamicBody(body: DynamicBody) {
    body.initPhysics(this.physicWorld)
    this.dynamicBodyList.push(body)
  }

  step() {
    const dt = this.clock.getDelta()
    const syncList = this.syncList
    for (var i = 0; i < syncList.length; i++) {
      syncList[i](dt)
    }

    for (let i = 0, rigidBodyList = this.rigidBodyList; i < rigidBodyList.length; i++) {
      const currBody = rigidBodyList[i]
      if (currBody.meshData && currBody.meshData.isMesh) {
        const motionStateIns = currBody.getMotionState()
        if (motionStateIns) {
          motionStateIns.getWorldTransform(this.TRANSFORM_AUX)
          const p = this.TRANSFORM_AUX.getOrigin()
          const q = this.TRANSFORM_AUX.getRotation()
          this.DEFAULTVECTOR3.set(p.x(), p.y(), p.z())
          this.DEFAULT_MATRIX3.setFromMatrix4((currBody.meshData as THREE.Mesh).matrixWorld)
          this.DEFAULTVECTOR3.applyMatrix3(this.DEFAULT_MATRIX3.invert())
          currBody.meshData.position.set(
            this.DEFAULTVECTOR3.x, this.DEFAULTVECTOR3.y, this.DEFAULTVECTOR3.z
          )
          currBody.meshData.quaternion.set(q.x(), q.y(), q.z(), q.w());
        }
      }
    }
    
    const meshes = this.meshes
    for ( let i = 0, l = meshes.length; i < l; i ++ ) {
      const mesh = meshes[i];
      // if ( mesh.isInstancedMesh ) {
      // 	const array = mesh.instanceMatrix.array;
      // 	const bodies = meshMap.get( mesh );
      // 	for ( let j = 0; j < bodies.length; j ++ ) {
      // 		const body = bodies[ j ];
      // 		compose( body.getPosition(), body.getOrientation(), array, j * 16 );
      // 	}
      // 	mesh.instanceMatrix.needsUpdate = true;
      // } else

      if ( mesh.isMesh ) {
        const body = this.meshesMap.get(mesh);
        // 获取刚体的状态
        var ms = body.getMotionState();
        if (ms) {
          ms.getWorldTransform(this.TRANSFORM_AUX);
          var p = this.TRANSFORM_AUX.getOrigin();
          var q = this.TRANSFORM_AUX.getRotation();
          mesh.position.set(p.x(), p.y(), p.z());
          mesh.quaternion.set(q.x(), q.y(), q.z(), q.w());
        }
      }

    }

    for (let i = 0; i < this.dynamicBodyList.length; i++) {
      const currBody = this.dynamicBodyList[i]
      currBody.update(dt)
    }
    
    // simulation 模拟
    this.physicWorld.stepSimulation( dt, 10 );
  }
}