import { CarScene } from "./CarScene"
import * as THREE from 'three'
import { RES } from "./module/RES"
import { ResJson } from "./ResJson"

window['THREE'] = THREE

export const loadAllGroup = function() {
  RES.loadConfig(ResJson)
  return RES.loadAllGroup()
}

export * from './message'
export class StageScene  {
  renderDom: HTMLCanvasElement
  stage: CarScene
  UIParentNode: HTMLElement

  constructor(
    canvas: HTMLCanvasElement,
    UIParentNode: HTMLElement
  ) {
    this.renderDom = canvas
    this.UIParentNode = UIParentNode
    this.initStage()
  }

  async initStage() {
    RES.loadConfig(ResJson)
    if (typeof Ammo === 'function') {
      // @ts-ignore
      Ammo().then(() => {
        this.stage = new CarScene(this.renderDom, this.UIParentNode)
      })
    } else {
      this.stage = new CarScene(this.renderDom, this.UIParentNode)
    }
    
    
  }

  destroy() {
    this.stage && this.stage.destroy()
  }
}