import * as OIMO from 'oimo';
import * as THREE from 'three'

export class OimoPhysicWorld {
  physicWorld: OIMO.World
  meshes: THREE.Mesh[] = []
  meshesMap: WeakMap<THREE.Mesh, OIMO.RigidBody> = new WeakMap()
  
  constructor() {

    this.initPhysicWorld()
  }

  initPhysicWorld() {
    this.physicWorld = new OIMO.World({
      timestep: 1 / 60,
      gravity: [0,-9.8,0] 
    })
    
  }

  createMeshPhysicBody(mesh: THREE.Mesh, cfg: Partial<OIMO.BodyConfig> = {}) {
    console.log(mesh.type, mesh, mesh.geometry)
    // @ts-expect-error
    const parameters = mesh.geometry.parameters;
    const geometry = mesh.geometry;
		if (geometry.type === 'BoxGeometry') {
			const sx = parameters.width !== undefined ? parameters.width : 0.5;
			const sy = parameters.height !== undefined ? parameters.height : 0.5;
			const sz = parameters.depth !== undefined ? parameters.depth : 0.5;
			return (this.physicWorld.add(Object.assign({
        type: 'box',
        pos: [mesh.position.x, mesh.position.y, mesh.position.z],
        size: [sx, sy, sz],
        move: true
      }, cfg)));

		}
    //  else if ( geometry.type === 'SphereGeometry' || geometry.type === 'IcosahedronGeometry' ) {

		// 	const radius = parameters.radius !== undefined ? parameters.radius : 1;

		// 	return new OIMO.OSphereGeometry( radius );

		// }



		return null;
  }

  addMesh(mesh: THREE.Mesh, config: Partial<OIMO.BodyConfig> = {}) {
    const ridigBody = this.createMeshPhysicBody(mesh, config)
    if (ridigBody) {
      this.meshes.push(mesh)
      this.meshesMap.set(mesh, ridigBody)
    }
    return ridigBody
  }

  step() {
    this.physicWorld.step();
    const meshes = this.meshes
    for ( let i = 0, l = meshes.length; i < l; i ++ ) {

			const mesh = meshes[i];

			// if ( mesh.isInstancedMesh ) {

			// 	const array = mesh.instanceMatrix.array;
			// 	const bodies = meshMap.get( mesh );

			// 	for ( let j = 0; j < bodies.length; j ++ ) {

			// 		const body = bodies[ j ];

			// 		compose( body.getPosition(), body.getOrientation(), array, j * 16 );
			// 	}
			// 	mesh.instanceMatrix.needsUpdate = true;
			// } else 
      if ( mesh.isMesh ) {
				const body = this.meshesMap.get(mesh);
				mesh.position.copy(body.getPosition());
				mesh.quaternion.copy(body.getQuaternion());

			}

		}
  }
}