type CreateElementProps = Partial<{
  attrs: Record<string, string>,
  styles: Partial<CSSStyleDeclaration>,
  events: Partial<Record<keyof WindowEventMap, {
    callback: (this: HTMLObjectElement) => any,
    options?: boolean | AddEventListenerOptions
  }>>
}>

export const Dom = new Proxy(({} as Record<keyof HTMLElementTagNameMap, (p: CreateElementProps, ...children: HTMLObjectElement[] | string[]) => HTMLObjectElement>), {
  get(target, property: keyof HTMLElementTagNameMap) {
    return function(props:CreateElementProps  = {}, ...children: HTMLObjectElement[] | string[]) {
      const el = document.createElement(property);
      const attrs = props.attrs
      const styles = props.styles
      const events = props.events
      if (
        attrs
      ) {
        for (let prop in attrs) {
          el.setAttribute(prop, attrs[prop]);
        }
      }

      if (styles) {
        for (let k in styles) {
          el.style[k] = styles[k]
        }
      }

      if (
        events
      ) {
        for (let eventName in events) {
          const cfg = events[eventName as keyof WindowEventMap]
          el.addEventListener(eventName, cfg.callback, cfg.options)
        }
      }

      for (let child of children) {
        if (typeof child === 'string') {
          console.log('child')
          // @ts-ignore
          child = document.createTextNode(child);
        }
        // @ts-ignore
        child && el.appendChild(child);
      }
      return el;
    }
  }
});