/*
 * runScript.js
 * Created by 还有醋v on 2021/5/8.
 * Copyright © 2021 haiyoucuv. All rights reserved.
 */
const childProcess = require('child_process');

module.exports = function runScript(scriptPath, callback) {

	let invoked = false;

	const process = childProcess.fork(scriptPath);

	process.on('error', function (err) {
		if (invoked) return;
		invoked = true;
		callback(err);
	});

	process.on('exit', function (code) {
		if (invoked) return;
		invoked = true;
		const err = code === 0 ? null : new Error('exit code ' + code);
		callback(err);
	});

}
