const _defaultJsx = require('@babel/plugin-syntax-jsx').default
const targetArr = ['log'].map(r => `console.${r}`)

const config = {
  pragma: 'Light.createElement'
}

module.exports = function(api) {
  const {
    types,
    template
  } = api

  function toMemberExpress(str) {
    return str.split('.').map(n => types.identifier(n)).reduce((pre, curr) => types.memberExpression(pre, curr))
  }

  function CallCreateElementExpression(args) {
    const t = types.cloneNode(toMemberExpress(config.pragma))
    return types.callExpression(t, args)
  }

  function getTag(n) {
    const tagExp = convertJSXIdentifier(n.node.name)
    let tagName

    if (types.isIdentifier(tagExp)) {
      tagName = tagExp.name
    } else if (types.isStringLiteral(tagExp)) {
      tagName = tagExp.value
    }

    if (tagName && /^[a-z]*$/.test(tagName)) {
      return types.stringLiteral(tagName)
    } else {
      return tagExp
    }

  }

  /**
   *  转化jsxName
   * @param {*} node 
   * @returns 
   */
  function convertJSXIdentifier(node) {
    if (types.isJSXIdentifier(node)) {
      if (types.isValidIdentifier(node.name, false)) {
        node.type = "Identifier" // 这里是因为下面的 type。memberExpression 需要type 为 Identifier的
      } else {
        return types.stringLiteral(node.name)
      }
      
    } else if (types.isJSXMemberExpression(node)) {
      return types.memberExpression(convertJSXIdentifier(node.object), convertJSXIdentifier(node.property))
    }
    return node
  }

  function initProps(path) {
    const attribs = path.get('attributes')
    const objs = []
    attribs.reduce(function(pre, cur) {
      const node = cur.node
      if (types.isJSXSpreadAttribute(cur)) {
        const arg = node.argument
        if (types.isObjectExpression(arg)) {
          pre.push(...arg.properties)
        } else {
          pre.push(types.spreadElement(arg))
        }
        return pre
      }
      const t = cur.node.value || types.booleanLiteral(true)
      const value = types.isJSXExpressionContainer(t) ? t.expression : t

      if (types.isValidIdentifier(node.name.name, false)) {
        node.name.type = "Identifier"
      }

      pre.push(types.objectProperty(node.name, value))
      return pre
    }, objs)
    return types.objectExpression(objs)
  }

  function buildCreateElementExp(path) {
    const openELe = path.get('openingElement')
    return CallCreateElementExpression([getTag(openELe), initProps(openELe), ...types.react.buildChildren(path.node)])
  }

  return {
    inherits: _defaultJsx,
    visitor: {
      ArrowFunctionExpression(path, state) {
        const node = path.node
        console.log(node)
        const params = node.params
        let body = node.body
    
        if (!types.isBlockStatement(body)) {
          body = types.blockStatement([types.returnStatement(body)])
        }
    
        const functionExpression = types.functionExpression(null, params, body)
        path.replaceWith(functionExpression)
      },
      CallExpression(path) {
        const node = path.node
        if (node.isSkip) return
        const calleeStr = path.get('callee').toString()
        if (targetArr.includes(calleeStr)) {
          let newLog = template.expression(`console.log('%c%s', 'color: green', '=======test=====')`)()
          path.insertBefore(newLog)
          newLog.isSkip = true
          node.isSkip = true
        }
      },
      Program: {
        enter(path) {
          const pragma = config.pragma
    
        }
      },
      JSXElement: {
        exit(path, state) {
          const node = path.node
          const openEle = path.get('openingElement')
          const newNode = buildCreateElementExp(path)
          path.replaceWith(newNode)
        }
      }
    }
  }
}