const parser = require('@babel/parser')
const traverse = require('@babel/traverse').default
const generator = require('@babel/generator').default
const types = require('@babel/types')
const template = require('@babel/template').default

const sourceCode = `
console.log(a)
class TT {
  render() {
    console.log(123)
  }
}
`

const ast = parser.parse(sourceCode, {
  sourceType: 'unambiguous'
})

const targetArr = ['log'].map(r => `console.${r}`)

traverse(ast, {
  CallExpression(path) {
    const node = path.node
    if (node.isSkip) return
    const calleeStr = path.get('callee').toString()
    if (targetArr.includes(calleeStr)) {
      let newLog = template.expression(`console.log('%c%s', 'color: green', '=======test=====')`)()
      path.insertBefore(newLog)
      newLog.isSkip = true
      node.isSkip = true
    }
  }
})

const {
  code
} = generator(ast)

console.log(code)

