const parser = require('@babel/parser')
const traverse = require('@babel/traverse').default
const generator = require('@babel/generator').default
const types = require('@babel/types')

const sourceCode = `
const gn = (a, b) => a + b;
const fb = function(a, b) {var c =3; return a + b};
`

const ast = parser.parse(sourceCode, {
  sourceType: 'unambiguous'
})

traverse(ast, {
  ArrowFunctionExpression(path, state) {
    const node = path.node
    const params = node.params
    let body = node.body

    if (!types.isBlockStatement(body)) {
      body = types.blockStatement([types.returnStatement(body)])
    }

    const functionExpression = types.functionExpression(null, params, body)
    path.replaceWith(functionExpression)
  }
})

const {
  code
} = generator(ast)

console.log(code)

