const path = require('path')

module.exports = {
  mode: 'development',
  devtool: 'source-map',
  entry: {
    index: './src/index'
  },
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        exclude: /(node_modules)/,
        use: [
          {
          loader: 'babel-loader',
          }
        ],
        exclude: /node_modules/
      }
    ],
  },
  resolve: {
    alias: {
      '@': './src'
    },
    extensions: ['.tsx', '.ts', '.js']
  },
  output: {
    filename: 'output.js',
    path: __dirname, // path.resolve(__dirname, './dist'),
    libraryTarget: 'umd'
  }
}