import { DreamContainer } from "../../components/DreamContainer/DreamContainer";
import { DreamSpine, setSpineAni } from "../../components/DreamSpine/DreamSpine";
import { DreamSprite } from "../../components/DreamSprite/DreamSprite";
import Dream from "../../Dream";
import { RES } from "../../modules/RES";
import { Tools } from "../../tools/Tools";
import { GameConfig } from "./GameConfig";

export enum RabbitActionMap {
  Normal = 'daijizc',
  Smile = 'daijizcxiao',
  Fail = 'daijiku',
  Jump = 'jump'
}

export type PlayerIns = {
  showAni: (a: RabbitActionMap, b?: RabbitActionMap) => Promise<any>
}

export class RabbitPlayer extends Dream.RenderContainer<{
  inlineProps?: Record<string, any>,
  getPlayer?: (p: PlayerIns) => void
}> {
  spinePlayer: FYGE.Spine
  currAniName: RabbitActionMap

  didRendered(): void {
    this.props.getPlayer && this.props.getPlayer({
      showAni: (aniName: RabbitActionMap, endAni?: RabbitActionMap) => {
        this.currAniName = aniName
        return new Promise<void>(resolve => {
          setSpineAni(this.spinePlayer, aniName, endAni ? 1 : 0, () => {
            endAni && setSpineAni(this.spinePlayer, endAni)
            resolve()
          })
        })
      }
    })
  }

  render() {
    const spineData = RES.getRes('rabbit0.spi')

    return (
      <DreamContainer inlineProps={{
        ...this.props.inlineProps,
        anchorX: 75
      }}>
        <DreamContainer inlineProps={{
          x: GameConfig.rabbitConfig.offsetX,
          y: GameConfig.rabbitConfig.offsetY
        }}>
          {/* <DreamSprite src={RES.getRes('rabbit.png')} /> */}
          <DreamSpine ref={el => {
            this.spinePlayer = el
          }} spineData={spineData}
            aniName={"daijizc"}
            skinName={Tools.PageData.skinName}
          />
        </DreamContainer>
      </DreamContainer>
    )
  }
}