import { OriginalElementWidthEvents } from "../../Dream";

export const DreamTextField: OriginalElementWidthEvents<{
  text: string,
  color?: string,
  size?: number,
  textWidth?: number,
  align?: FYGE.TEXT_ALIGN,
  bold?: boolean,
  textHeight?: number
  verticalAlign?: FYGE.VERTICAL_ALIGN
  stroke?: number
  strokeColor?: string
}, FYGE.TextField> = ({
  text,
  color='#000000',
  size=30,
  textWidth,
  align=FYGE.TEXT_ALIGN.CENTER,
  bold=false,
  textHeight,
  verticalAlign = FYGE.VERTICAL_ALIGN.MIDDLE,
  stroke = 0,
  strokeColor = '#000000'
}) => {
  const textIns = new FYGE.TextField()
  textIns.fillColor = color;
  textIns.size = size;
  textWidth && (textIns.textWidth = textWidth);
  textIns.textAlign = align;
  textIns.text = text;
  textIns.bold = bold
  textHeight && (textIns.textHeight = textHeight)
  textIns.verticalAlign = verticalAlign

  textIns.stroke = stroke
  textIns.strokeColor = strokeColor

  return textIns
}